package com.cku.oa.timedtask.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.cku.oa.groomer.service.GroomerQualificationCertificateService;

@Service
@Transactional(readOnly = true)
public class GroomerQualificationCertificateTask extends JobActingService{

	@Autowired
	private GroomerQualificationCertificateService groomerQualificationCertificateService;
	
	@SuppressWarnings("finally")
	@Transactional(readOnly = false)
	int doJob() {
		int count = 0;
		try {
			count = groomerQualificationCertificateService.deleteQualificationCertificate();
		} catch (Exception e) {
			count = -1;
		} finally {
			return count;
		}
	}

	@Override
	@SuppressWarnings("finally")
	@Transactional(readOnly = false)
	public int executeOnce() {
		int count = 0;
		try {
			SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
			count = groomerQualificationCertificateService.deleteQualificationCertificate();
		} catch (Exception e) {
			count = -1;
		} finally {
			return count;
		}
	}
	
	

}
