package com.cku.oa.timedtask.service;

import com.cku.restful.v1.dog.service.RestDogDnaBloodService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@Service
@Transactional(readOnly = true)
public class DogDnaBloodTask extends JobActingService {
	
	private final Logger logger = LoggerFactory.getLogger(getClass());
	
	@Autowired
	private RestDogDnaBloodService restDogDnaBloodService;

	@SuppressWarnings("finally")
	@Transactional(readOnly = false)
	int doJob() {
		int count = 0;
		try {
			restDogDnaBloodService.updatePedigreeCertified();
		} catch (Exception e) {
			count = -1;
		} finally {
			logger.info("修改数据,执行条数：" + count);
			return count;
		}
	}

	@SuppressWarnings("finally")
	@Transactional(readOnly = false)
	public int executeOnce() {
		int count = 0;
		try {
			SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
			restDogDnaBloodService.updatePedigreeCertified();
		} catch (Exception e) {
			count = -1;
		} finally {
			logger.info("修改数据,执行条数：" + count);
			return count;
		}
	}

}
