/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.tcb.entity;

import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.sys.entity.user.Member;
import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import javax.validation.constraints.NotNull;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 淘宠宝犬舍Entity
 * @author lgl
 * @version 2017-02-21
 */
public class TcbKennel extends DataEntity<TcbKennel> {
	
	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private String contractCode;		// 合同编号
	private Date startDate;		// 有效期开始
	private Date endDate;		// 有效期结束

	private Member member;		// 会员信息
	private Kennel kennel;		// 犬舍信息

	public TcbKennel() {
		super();
	}

	public TcbKennel(String id){
		super(id);
	}

	@Length(min=1, max=64, message="会员号长度必须介于 1 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=1, max=64, message="合同编号长度必须介于 1 和 64 之间")
	public String getContractCode() {
		return contractCode;
	}

	public void setContractCode(String contractCode) {
		this.contractCode = contractCode;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message="有效期开始不能为空")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@NotNull(message="有效期结束不能为空")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public Kennel getKennel() {
		return kennel;
	}

	public void setKennel(Kennel kennel) {
		this.kennel = kennel;
	}

	private String valid;		//是否有效	0:有效；1:无效

	public String getValid() {
		if(id!=null){
			if(startDate!=null&&endDate!=null){
				long now = System.currentTimeMillis();
				if(now>startDate.getTime()&&now<endDate.getTime()){
					return "0";
				}else{
					return "1";
				}
			}else{
				return "1";
			}
		}
		return valid;
	}

	public void setValid(String valid) {
		this.valid = valid;
	}
}