package com.cku.oa.sys.web;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.sys.entity.ExpressReceive;
import com.cku.oa.sys.service.ExpressReceiveService;

/**
 * 收件记录Controller
 * @author fanhuibin
 * @version 2016-08-31
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/expressReceive")
public class ExpressReceiveController extends BaseController {

	@Autowired
	private ExpressReceiveService expressReceiveService;
	
	@ModelAttribute
	public ExpressReceive get(@RequestParam(required=false) String id) {
		ExpressReceive entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = expressReceiveService.get(id);
		}
		if (entity == null){
			entity = new ExpressReceive();
		}
		return entity;
	}
	
	@RequiresPermissions("sys:expressReceive:view")
	@RequestMapping(value = {"list", ""})
	public String list(ExpressReceive expressReceive, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ExpressReceive> page = expressReceiveService.findPage(new Page<ExpressReceive>(request, response), expressReceive); 
		//将page中的content内容解析为可读的内容
		List<ExpressReceive> list = page.getList();
		for(ExpressReceive e:list){
			String content = e.getContent();
			String contentName = e.getContentName();
			String[] names = contentName.split( "\\|",-1);
			String[] contents = content.split("\\|",-1);
			StringBuilder builder = new StringBuilder();
			for(int i=0;i<names.length;i++){
				if(!contents[i].equals("")){
					builder.append(contents[i]+"份 "+names[i]+"<br/>");
				}
			}
			e.setContent(builder.toString());
		}
		
		model.addAttribute("page", page);
		return "oa/sys/expressReceiveList";
	}

	@RequiresPermissions("sys:expressReceive:view")
	@RequestMapping(value = "form")
	public String form(ExpressReceive expressReceive, Model model) {
		model.addAttribute("expressReceive", expressReceive);
		return "oa/sys/expressReceiveForm";
	}

	@RequiresPermissions("sys:expressReceive:view")
	@RequestMapping(value = "save")
	public String save(ExpressReceive expressReceive, Model model, RedirectAttributes redirectAttributes,HttpServletRequest request) {
		String[] content = request.getParameterValues("cardNum");
		StringBuilder builder = new StringBuilder();
		for(int i=0;i<content.length;i++){
			builder.append(content[i]);
			if(i+1 != content.length){
				builder.append("|");
			}
		}
		expressReceive.setContent(builder.toString());
		 boolean hasPermission = false;
	        if(!StringUtils.isEmpty(expressReceive.getId())){
	            hasPermission = SecurityUtils.getSubject().isPermitted("sys:expressReceive:edit");
	        }else{
	            hasPermission = SecurityUtils.getSubject().isPermitted("sys:expressReceive:add");
	        }
	        if(hasPermission){
	            if (!beanValidator(model, expressReceive)){
	                return form(expressReceive, model);
	            }
	            expressReceiveService.save(expressReceive);
	            addMessage(redirectAttributes, "保存收件记录成功");
	        }else{
	            throw new UnauthenticatedException();
	        }
		return "redirect:"+Global.getAdminPath()+"/sys/expressReceive/?repage";
	}
	
	@RequiresPermissions("sys:expressReceive:delete")
	@RequestMapping(value = "delete")
	public String delete(ExpressReceive expressReceive, RedirectAttributes redirectAttributes) {
		expressReceiveService.delete(expressReceive);
		addMessage(redirectAttributes, "删除收件记录成功");
		return "redirect:"+Global.getAdminPath()+"/sys/expressReceive/?repage";
	}

}