package com.cku.oa.sys.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.sys.dao.TaskLogDao;
import com.cku.oa.sys.entity.TaskLog;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 计划任务执行日志Service
 * 
 * @author zhuoHeng
 * @version 2017-03-31
 */
@Service
@Transactional(readOnly = true)
public class TaskLogService extends CrudService<TaskLogDao, TaskLog> {

	public TaskLog get(String id) {
		return super.get(id);
	}

	public List<TaskLog> findList(TaskLog taskLog) {
		return super.findList(taskLog);
	}

	public Page<TaskLog> findPage(Page<TaskLog> page, TaskLog taskLog) {
		return super.findPage(page, taskLog);
	}

	@Transactional(readOnly = false)
	public void save(TaskLog taskLog) {
		super.save(taskLog);
	}

	@Transactional(readOnly = false)
	public void delete(TaskLog taskLog) {
		super.delete(taskLog);
	}

	/**
	 * 
	 * @Description：日志写入
	 * @author: zhuoHeng
	 * @version: 2017年3月31日 下午3:15:07
	 */
	@Transactional(readOnly = false)
	public void addLog(TaskLog taskLog) {
		dao.insert(taskLog);
	}

	/**
	 * 
	 * @Description：校验当天执行次数
	 * @author: zhuoHeng
	 * @version: 2017年4月5日 下午3:38:26
	 */
	public TaskLog validateExecute(String jobName) {
		return dao.validateExecute(jobName);
	}

}