package com.cku.oa.sys.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.sys.entity.SysOrgPrint;
import com.cku.oa.sys.dao.SysOrgPrintDao;

/**
 * 俱乐部打印重置Service
 * @author cxt
 * @version 2017-10-24
 */
@Service
@Transactional(readOnly = true)
public class SysOrgPrintService extends CrudService<SysOrgPrintDao, SysOrgPrint> {

	public SysOrgPrint get(String id) {
		return super.get(id);
	}
	
	public List<SysOrgPrint> findList(SysOrgPrint sysOrgPrint) {
		return super.findList(sysOrgPrint);
	}
	
	public Page<SysOrgPrint> findPage(Page<SysOrgPrint> page, SysOrgPrint sysOrgPrint) {
		return super.findPage(page, sysOrgPrint);
	}
	
	@Transactional(readOnly = false)
	public void save(SysOrgPrint sysOrgPrint) {
		super.save(sysOrgPrint);
	}
	
	@Transactional(readOnly = false)
	public void delete(SysOrgPrint sysOrgPrint) {
		super.delete(sysOrgPrint);
	}
	
	@Transactional(readOnly = false)
	public void updateRestPrint(String orgId) {
		SysOrgPrint sysOrgPrint=dao.getByOrgId(orgId);
		if(sysOrgPrint!=null){
			sysOrgPrint.setRestPrintCode("3");
			super.save(sysOrgPrint);
		}
	}
}