package com.cku.oa.sys.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

public class SysMemberKennelModifyLog extends DataEntity<SysMemberKennelModifyLog> {

	private static final long serialVersionUID = 1L;
	private String memberCode; // 会员号
	private String sqlInfo; // sql
	private String content; // 变更内容描述
	private String orderNo; // 工单编号
	private Date createTime; // create_time
	private Date updateTime; // update_time
	private String source; // 变更来源：SQL，OA

	public SysMemberKennelModifyLog() {
		super();
	}

	public SysMemberKennelModifyLog(String id) {
		super(id);
	}

	@Length(min = 1, max = 60, message = "会员号长度必须介于 1 和 60 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getSqlInfo() {
		return sqlInfo;
	}

	public void setSqlInfo(String sqlInfo) {
		this.sqlInfo = sqlInfo;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	@Length(min = 0, max = 20, message = "工单编号长度必须介于 0 和 20 之间")
	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

	@Length(min = 0, max = 20, message = "变更来源：SQL，OA长度必须介于 0 和 20 之间")
	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

}