/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 登录服务Entity
 * @author cxt
 * @version 2017-12-07
 */
public class LoginServer extends DataEntity<LoginServer> {
	
	private static final long serialVersionUID = 1L;
	private String userType;		// 用户类型
	private String userTypeName;		// 用户类型名称
	private String dogType;		// 犬种
	private String isSupport;		// 0:支持,1不支持
	private String userShortName;   //用户类型缩写 对应不同注册页传入的值写入userType
	private String memberSite;     //会员站点 限制绑定功能  0代表不可绑定任何会员站点 空为CKU会员 其他类型均匀userType相同
	private String userTypeNameEn;     //用户类型名称英文		用于作为loginType
	private String isAlike;   //是否同套操作系统
	public LoginServer() {
		super();
	}

	public LoginServer(String id){
		super(id);
	}

	@Length(min=0, max=64, message="用户类型长度必须介于 0 和 64 之间")
	public String getUserType() {
		return userType;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}
	
	@Length(min=0, max=255, message="用户类型名称长度必须介于 0 和 255 之间")
	public String getUserTypeName() {
		return userTypeName;
	}

	public void setUserTypeName(String userTypeName) {
		this.userTypeName = userTypeName;
	}
	
	@Length(min=0, max=255, message="犬种长度必须介于 0 和 255 之间")
	public String getDogType() {
		return dogType;
	}

	public void setDogType(String dogType) {
		this.dogType = dogType;
	}
	
	@Length(min=0, max=255, message="0:支持,1不支持长度必须介于 0 和 255 之间")
	public String getIsSupport() {
		return isSupport;
	}

	public void setIsSupport(String isSupport) {
		this.isSupport = isSupport;
	}

	public String getUserShortName() {
		return userShortName;
	}

	public void setUserShortName(String userShortName) {
		this.userShortName = userShortName;
	}

	public String getMemberSite() {
		return memberSite;
	}

	public void setMemberSite(String memberSite) {
		this.memberSite = memberSite;
	}

	public String getUserTypeNameEn() {
		return userTypeNameEn;
	}

	public void setUserTypeNameEn(String userTypeNameEn) {
		this.userTypeNameEn = userTypeNameEn;
	}

	public String getIsAlike() {
		return isAlike;
	}

	public void setIsAlike(String isAlike) {
		this.isAlike = isAlike;
	}
	
}