/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.sys.entity.ExpressSend;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 邮寄发件DAO接口
 *
 * @author fanhuibin
 * @version 2016-09-01
 */
@MyBatisDao
public interface ExpressSendDao extends CrudDao<ExpressSend> {
	// 重置打印
	void updatePrint(@Param("id") String id, @Param("printState") String printState);

	// 根据content字段进行模糊查询
	ExpressSend getByMemberCodeAndContent(@Param("memberCode") String memberCode, @Param("content") String content);

	ExpressSend selectByOrderNo(@Param("expressNo") String expressNo);

	// 修改签收日期
	Integer updateReceiveDate(ExpressSend expressSend);

	/**
	 * 查询五日内未签收的数据
	 */
	List<ExpressSend> selectOvertimeData();

	void updateDownUlr(@Param("otherExpressNo") String otherExpressNo , @Param("url")String url);
	
	int getOtherExpressNo(@Param("otherExpressNo") String otherExpressNo);
}