/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.statistics.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 商城销售统计Entity
 * @author chy
 * @version 2017-12-19
 */
public class ShopSalesStatistics extends DataEntity<ShopSalesStatistics> {
	
	private static final long serialVersionUID = 1L;
	@ExcelField(title="商品名称", align=2, sort=2)
	private String commodityName;		// 商品名称
	@ExcelField(title="商品类别", align=2, sort=3)
	private String commodityType;		// 商品类别
	@ExcelField(title="统计时间", align=2, sort=4)
	private String statisticalDate;		// 统计时间
	@ExcelField(title="总计数量", align=2, sort=5)
	private String commodityNum;		// 总计数量
	@ExcelField(title="总计金额", align=2, sort=6)
	private String totalAmount;		// 总计金额
	
	private String statisticalDateFrom; //起始统计时间
	
	private String statisticalDateTo;//结束统计时间
	
	
	

	public String getStatisticalDateFrom() {
		return statisticalDateFrom;
	}

	public void setStatisticalDateFrom(String statisticalDateFrom) {
		this.statisticalDateFrom = statisticalDateFrom;
	}

	public String getStatisticalDateTo() {
		return statisticalDateTo;
	}

	public void setStatisticalDateTo(String statisticalDateTo) {
		this.statisticalDateTo = statisticalDateTo;
	}

	public ShopSalesStatistics() {
		super();
	}

	public ShopSalesStatistics(String id){
		super(id);
	}

	@Length(min=0, max=200, message="商品名称长度必须介于 0 和 200 之间")
	public String getCommodityName() {
		return commodityName;
	}

	public void setCommodityName(String commodityName) {
		this.commodityName = commodityName;
	}
	
	@Length(min=0, max=50, message="商品类别长度必须介于 0 和 50 之间")
	public String getCommodityType() {
		return commodityType;
	}

	public void setCommodityType(String commodityType) {
		this.commodityType = commodityType;
	}
	
	public String getStatisticalDate() {
		return statisticalDate;
	}

	public void setStatisticalDate(String statisticalDate) {
		this.statisticalDate = statisticalDate;
	}

	@Length(min=0, max=11, message="总计数量长度必须介于 0 和 11 之间")
	public String getCommodityNum() {
		return commodityNum;
	}

	public void setCommodityNum(String commodityNum) {
		this.commodityNum = commodityNum;
	}
	
	public String getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}
	
	
}