/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.statistics.dao;

import com.cku.oa.statistics.entity.SaPaymentDetail;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 年费拆分到月DAO接口
 * @author fanhuibin
 * @version 2017-02-21
 */
@MyBatisDao
public interface SaPaymentDetailDao extends CrudDao<SaPaymentDetail> {

	public void batchInsert(List<SaPaymentDetail> batch);
	public List<Map> statisticsByType(@Param("startDate")String startDate, @Param("endDate")String endDate,@Param("type")String type);
	public List<Map> statisticsCsvByType(@Param("startDate")String startDate, @Param("endDate")String endDate,@Param("type")String type);
	public String currentConfired(@Param("startDate")String startDate, @Param("endDate")String endDate);
	public String currentUnconfired(@Param("startDate")String startDate, @Param("endDate")String endDate);
	public String currentShare(@Param("startDate")String startDate,@Param("endDate") String endDate);
	public List<SaPaymentDetail> findCsvList(SaPaymentDetail saPaymentDetail);

	public HashMap findByChargeItemCount(@Param("chargeItemId")String chargeItemId,@Param("sourceCharge")String sourceCharge);

	public HashMap findCountByRunningNumber(@Param("runningNumber")String runningNumber);


	public int updateCount(@Param("id")String id,@Param("orderCon")String orderCon,@Param("orderTotal")String orderTotal,@Param("recordCon")String recordCon,@Param("recordTotal")String recordTotal,@Param("saCon")String saCon,@Param("saTotal")String saTotal);

	List<Map<String,Object>> findInstallmentBalance(@Param("end") String end);

}