package com.cku.oa.statistics.dao;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.statistics.entity.ClubStatisticsInfo;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 活动报名信息统计的数据库查询
 * @author xuzhenxing
 *
 */
@MyBatisDao
public interface ClubStatisticsDao {

	List<Map> countByDate(@Param("startDate")String startDate, @Param("endDate")String endDate,@Param("name")String name,@Param("state")String state,@Param("area")String area);


	//统计2017-06-01地方俱乐部办理业务的数量
	List<Map> countByNewDate(@Param("startDate")String startDate, @Param("endDate")String endDate,@Param("name")String name,@Param("state")String state,@Param("area")String area);

	//2017-06-01前后业务合并统计
	List<Map> countAll(@Param("startDate")String startDate, @Param("endDate")String endDate,@Param("name")String name,@Param("state")String state,@Param("area")String area);

	List<Map> countClubByNewDate(@Param("startDate") String startDate, @Param("endDate") String endDate, @Param("name") String name, @Param("area")String area);

    List<Map> myIncome(@Param("startDate") String startDate, @Param("endDate") String endDate, @Param("name") String name, @Param("area")String area);
    List<Map> income(@Param("startDate") String startDate, @Param("endDate") String endDate, @Param("name") String name, @Param("memberCode") String memberCode,@Param("orgType") String orgType,@Param("tuijiansren") String tuijiansren);

	/**
	 * @Description： 统计单犬种地方俱乐部
	 * @author: yuanshuai
	 * @date: 2019/10/17 14:58
	 */
	List<Map> findSingleTypeClubCountByNewDate(@Param("startDate")String startDate, @Param("endDate")String endDate,@Param("name")String name,@Param("state")String state,@Param("area")String area);

	/**
	 * @Description： 统计单犬种地方俱乐部
	 * @author: yuanshuai
	 * @date: 2019/10/17 14:58
	 */
	List<Map> myIncomeSingleType(@Param("startDate") String startDate, @Param("endDate") String endDate, @Param("name") String name, @Param("area")String area);

    Map getCertified(@Param("startDate") String startDate, @Param("endDate") String endDate,@Param("memberCode") String memberCode,@Param("orgType") String orgType);
    
    List<ClubStatisticsInfo> getCertifiedByMemberCodes(@Param("startDate") String startDate, @Param("endDate") String endDate,@Param("memberCodes") List<String> memberCodes,@Param("orgType") String orgType);

    /**
	* @Description:  统计收支明细
	* @author: zhangxiang
	* @date: 2020/7/14 11:49
	*/
}
