/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 赛事成绩排名表Entity
 * @author xx
 * @version 2021-07-20
 */
public class ShowScoreRanking extends DataEntity<ShowScoreRanking> {
	
	private static final long serialVersionUID = 1L;
	@ExcelField(title = "血统证书号", align = 2, sort = 5)
	private String pedigreeCertified;		// 血统证书号
	private String year;		// 官网成绩排名所属年份
	private String month;		// 月份
	private String scoreType;		// 积分类型 1特幼犬组 2幼小犬组 3成年犬组 20本土繁殖积分榜 ohc犬主人组 bbe繁殖人组
	@ExcelField(title = "积分", align = 2, sort = 2)
	private Double score;		// 积分
	private String dogBreedGroup;		// 犬种组
	private String dogBreed;		// 犬种
	@ExcelField(title = "排行", align = 2, sort = 1)
	private Integer ranking;		// 全犬种排名
	private Integer gorupRanking;		// 犬组排名
	private Integer dogBreedRanking;		// 犬种排名
	@ExcelField(title = "第一犬主/第二犬主", align = 2, sort = 6)
	private String dogOwner; // 犬主人
	@ExcelField(title = "犬种中文名 ", align = 2, sort = 4)
	private String dogBreedNameCn; // 犬种中文名 
	private String dogBreedNameEn; // 犬种英文名
	@ExcelField(title = "犬名", align = 2, sort = 3)
	private String dogName; // 犬名
	private Integer rankLimit;	
	@ExcelField(title = "积分更新时间", align = 2, sort = 7)
	protected Date updateDateFExport;	// 更新日期
	@ExcelField(title = "积分榜标题", align = 2, sort = 8)
	private String title; // 积分榜标题
	private Integer gorupRankingLimit;
	private Integer dogBreedRankingLimit;
	
	private Integer limit;	//请求前多少个
	
	//犬舍名称
	private String kennlCnName;
	private String kennlEnName;

	//第二犬主人
	private String secondDogOwner;
	
	private String version;//积分榜版本号
	private String trend;//上升趋势 0持平 1上升 2下降
	
	private String key;//犬主人姓名和犬只证书号进行查询
	
	private String chineseGroupName;//犬种组中文名
	

	public String getMonth() {
		return month;
	}

	public void setMonth(String month) {
		this.month = month;
	}

	public String getChineseGroupName() {
		return chineseGroupName;
	}

	public void setChineseGroupName(String chineseGroupName) {
		this.chineseGroupName = chineseGroupName;
	}

	public Date getUpdateDateFExport() {
		return updateDateFExport;
	}

	public void setUpdateDateFExport(Date updateDateFExport) {
		this.updateDateFExport = updateDateFExport;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Integer getLimit() {
		return limit;
	}

	public void setLimit(Integer limit) {
		this.limit = limit;
	}

	public String getTrend() {
		return trend;
	}

	public void setTrend(String trend) {
		this.trend = trend;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public Integer getGorupRankingLimit() {
		return gorupRankingLimit;
	}

	public void setGorupRankingLimit(Integer gorupRankingLimit) {
		this.gorupRankingLimit = gorupRankingLimit;
	}

	public Integer getDogBreedRankingLimit() {
		return dogBreedRankingLimit;
	}

	public void setDogBreedRankingLimit(Integer dogBreedRankingLimit) {
		this.dogBreedRankingLimit = dogBreedRankingLimit;
	}

	public Integer getRankLimit() {
		return rankLimit;
	}

	public void setRankLimit(Integer rankLimit) {
		this.rankLimit = rankLimit;
	}

	public String getKennlCnName() {
		return kennlCnName;
	}

	public void setKennlCnName(String kennlCnName) {
		this.kennlCnName = kennlCnName;
	}

	public String getKennlEnName() {
		return kennlEnName;
	}

	public void setKennlEnName(String kennlEnName) {
		this.kennlEnName = kennlEnName;
	}

	public String getDogOwner() {
		return dogOwner;
	}

	public void setDogOwner(String dogOwner) {
		this.dogOwner = dogOwner;
	}

	public String getDogBreedNameCn() {
		return dogBreedNameCn;
	}

	public void setDogBreedNameCn(String dogBreedNameCn) {
		this.dogBreedNameCn = dogBreedNameCn;
	}

	public String getDogBreedNameEn() {
		return dogBreedNameEn;
	}

	public void setDogBreedNameEn(String dogBreedNameEn) {
		this.dogBreedNameEn = dogBreedNameEn;
	}

	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}


	public ShowScoreRanking() {
		super();
	}

	public ShowScoreRanking(String id){
		super(id);
	}

	@Length(min=0, max=64, message="血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}
	
	@Length(min=1, max=4, message="官网成绩排名所属年份长度必须介于 1 和 4 之间")
	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}
	
	@Length(min=0, max=64, message="积分类型 1特幼犬组 2幼小犬组 3成年犬组 20本土繁殖积分榜 ohc犬主人组 bbe繁殖人组长度必须介于 0 和 64 之间")
	public String getScoreType() {
		return scoreType;
	}

	public void setScoreType(String scoreType) {
		this.scoreType = scoreType;
	}
	
	public Double getScore() {
		return score;
	}

	public void setScore(Double score) {
		this.score = score;
	}
	
	@Length(min=0, max=10, message="犬种组长度必须介于 0 和 10 之间")
	public String getDogBreedGroup() {
		return dogBreedGroup;
	}

	public void setDogBreedGroup(String dogBreedGroup) {
		this.dogBreedGroup = dogBreedGroup;
	}
	
	@Length(min=0, max=64, message="犬种长度必须介于 0 和 64 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}
	
	public Integer getRanking() {
		return ranking;
	}

	public void setRanking(Integer ranking) {
		this.ranking = ranking;
	}
	
	public Integer getGorupRanking() {
		return gorupRanking;
	}

	public void setGorupRanking(Integer gorupRanking) {
		this.gorupRanking = gorupRanking;
	}
	
	public Integer getDogBreedRanking() {
		return dogBreedRanking;
	}

	public void setDogBreedRanking(Integer dogBreedRanking) {
		this.dogBreedRanking = dogBreedRanking;
	}

	public String getSecondDogOwner() {
		return secondDogOwner;
	}

	public void setSecondDogOwner(String secondDogOwner) {
		this.secondDogOwner = secondDogOwner;
	}
}