/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 播报成绩Entity
 * @author lyy
 * @version 2018-01-22
 */
public class ShowReportScore extends DataEntity<ShowReportScore> implements Cloneable{
	
	private static final long serialVersionUID = 1L;
	@ExcelField(title="犬展编号", align=2, sort=1)
	private String showCode;		// 赛事编号
	@ExcelField(title="秩序号", align=2, sort=2)
	private String orderNumber;		// 秩序号
	@ExcelField(title="犬主人", align=2, sort=3)
	private String dogOwnerZh;		// 犬主人中文名
	@ExcelField(title="犬主名（牵犬人名）", align=2, sort=4)
	private String dogOwnerHandler;		// 犬主牵犬师
	@ExcelField(title="会员号", align=2, sort=5)
	private String dogOwnerCode;		// 犬主会员号
	@ExcelField(title="犬种中文名", align=2, sort=6)
	private String dogTypeZh;		// 犬种中文
	@ExcelField(title="犬种英文名", align=2, sort=7)
	private String dogTypeEn;		// 犬种英文
	@ExcelField(title="犬名", align=2, sort=8)
	private String dogName;		// 犬名
	@ExcelField(title="性别", align=2, sort=9)
	private String dogSex;		// 性别
	@ExcelField(title="年龄组别", align=2, sort=10)
	private String dogYearGroup;		// 年龄组别名称
	@ExcelField(title="CKU血统证书号", align=2, sort=11)
	private String pedigreeCertifiedCode;		// 血统证书号
	@ExcelField(title="FCI",align = 2,sort = 12)
	private String fciCode;//FCI
	@ExcelField(title="赛圈",align = 2,sort = 13)
	private String showCircle;
	private String judgeId;
	private String judgeName;
	// 主赛事id
	private String mainShowId;
	//同期成绩
	private String otherResult;
	// 犬主人英文名
	private String dogOwnerEh;

	public ShowReportScore() {
		super();
	}

	public ShowReportScore(String id){
		super(id);
	}

	@Length(min=0, max=255, message="赛事编号长度必须介于 0 和 255 之间")
	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}
	
	@Length(min=0, max=10, message="秩序号长度必须介于 0 和 10 之间")
	public String getOrderNumber() {
		return orderNumber;
	}

	public void setOrderNumber(String orderNumber) {
		this.orderNumber = orderNumber;
	}
	
	@Length(min=0, max=50, message="犬主人中文名长度必须介于 0 和 50 之间")
	public String getDogOwnerZh() {
		return dogOwnerZh;
	}

	public void setDogOwnerZh(String dogOwnerZh) {
		this.dogOwnerZh = dogOwnerZh;
	}

	
	@Length(min=0, max=50, message="犬主会员号长度必须介于 0 和 50 之间")
	public String getDogOwnerCode() {
		return dogOwnerCode;
	}

	public void setDogOwnerCode(String dogOwnerCode) {
		this.dogOwnerCode = dogOwnerCode;
	}
	
	@Length(min=0, max=100, message="犬主牵犬师长度必须介于 0 和 100 之间")
	public String getDogOwnerHandler() {
		return dogOwnerHandler;
	}

	public void setDogOwnerHandler(String dogOwnerHandler) {
		this.dogOwnerHandler = dogOwnerHandler;
	}

	public String getMainShowId() {
		return mainShowId;
	}

	public void setMainShowId(String mainShowId) {
		this.mainShowId = mainShowId;
	}

	@Length(min=0, max=100, message="犬种中文长度必须介于 0 和 100 之间")

	public String getDogTypeZh() {
		return dogTypeZh;
	}

	public void setDogTypeZh(String dogTypeZh) {
		this.dogTypeZh = dogTypeZh;
	}
	
	@Length(min=0, max=100, message="犬种英文长度必须介于 0 和 100 之间")
	public String getDogTypeEn() {
		return dogTypeEn;
	}

	public void setDogTypeEn(String dogTypeEn) {
		this.dogTypeEn = dogTypeEn;
	}

	
	@Length(min=0, max=100, message="犬名长度必须介于 0 和 100 之间")
	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}
	
	@Length(min=0, max=2, message="性别长度必须介于 0 和 2 之间")
	public String getDogSex() {
		return dogSex;
	}

	public void setDogSex(String dogSex) {
		this.dogSex = dogSex;
	}
	

	
	@Length(min=0, max=50, message="年龄组别名称长度必须介于 0 和 50 之间")
	public String getDogYearGroup() {
		return dogYearGroup;
	}

	public void setDogYearGroup(String dogYearGroup) {
		this.dogYearGroup = dogYearGroup;
	}

	
	@Length(min=0, max=50, message="血统证书号长度必须介于 0 和 50 之间")
	public String getPedigreeCertifiedCode() {
		return pedigreeCertifiedCode;
	}

	public void setPedigreeCertifiedCode(String pedigreeCertifiedCode) {
		this.pedigreeCertifiedCode = pedigreeCertifiedCode;
	}

	public String getFciCode() {
		return fciCode;
	}

	public void setFciCode(String fciCode) {
		this.fciCode = fciCode;
	}

	public String getShowCircle() {
		return showCircle;
	}

	public void setShowCircle(String showCircle) {
		this.showCircle = showCircle;
	}

	public String getJudgeId() {
		return judgeId;
	}

	public void setJudgeId(String judgeId) {
		this.judgeId = judgeId;
	}
	public String getJudgeName() {
		return judgeName;
	}

	public void setJudgeName(String judgeName) {
		this.judgeName = judgeName;
	}

	public String getOtherResult() {
		return otherResult;
	}

	public void setOtherResult(String otherResult) {
		this.otherResult = otherResult;
	}

	public String getDogOwnerEh() {
		return dogOwnerEh;
	}

	public void setDogOwnerEh(String dogOwnerEh) {
		this.dogOwnerEh = dogOwnerEh;
	}

	public Object clone() throws CloneNotSupportedException{
		return super.clone();
	}
}