/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.shop.entity;

import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 商品销售渠道Entity
 * @author lyy
 * @version 2016-08-15
 */
public class ShopSaleChannel extends DataEntity<ShopSaleChannel> {
	
	private static final long serialVersionUID = 1L;
	@ExcelField(title="编号", align=2, sort=1)
	private String code;		// 编号
	@ExcelField(title="名称", align=2, sort=2)
	private String name;		// 名称
	private String dept;		// 部门
	@ExcelField(title="部门名称", align=2, sort=3)
	private String deptName;	//部门名称
	@ExcelField(title="职位", align=2, sort=4)
	private String position;		// 职位
	@ExcelField(title="渠道类型", align=2, sort=5)
	private String type;		// 渠道类型
	private String area;		// 区域
	@ExcelField(title="区域名称", align=2, sort=6)
	private String areaName;	//区域名称
	@ExcelField(title="联系方式1", align=2, sort=7)
	private String linkMobile1;		// 联系方式1
	@ExcelField(title="联系方式2", align=2, sort=8)
	private String linkMobile2;		// 联系方式2
	@ExcelField(title="是否有效", align=2, sort=9)
	private String isValid;		// 是否有效
	
	public ShopSaleChannel() {
		super();
	}

	public ShopSaleChannel(String id){
		super(id);
	}

	@Length(min=1, max=64, message="编号长度必须介于 1 和 64 之间")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@Length(min=0, max=100, message="名称长度必须介于 0 和 100 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=0, max=64, message="部门长度必须介于 0 和 64 之间")
	public String getDept() {
		return dept;
	}

	public void setDept(String dept) {
		this.dept = dept;
	}
	
	@Length(min=0, max=50, message="职位长度必须介于 0 和 50 之间")
	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}
	
	@Length(min=0, max=10, message="渠道类型长度必须介于 0 和 10 之间")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	@Length(min=0, max=64, message="区域长度必须介于 0 和 64 之间")
	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}
	
	@Length(min=0, max=50, message="联系方式1长度必须介于 0 和 50 之间")
	public String getLinkMobile1() {
		return linkMobile1;
	}

	public void setLinkMobile1(String linkMobile1) {
		this.linkMobile1 = linkMobile1;
	}
	
	@Length(min=0, max=50, message="联系方式2长度必须介于 0 和 50 之间")
	public String getLinkMobile2() {
		return linkMobile2;
	}

	public void setLinkMobile2(String linkMobile2) {
		this.linkMobile2 = linkMobile2;
	}
	
	@Length(min=0, max=2, message="是否有效长度必须介于 0 和 2 之间")
	public String getIsValid() {
		return isValid;
	}

	public void setIsValid(String isValid) {
		this.isValid = isValid;
	}

	public String getDeptName() {
		return deptName;
	}

	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}

	public String getAreaName() {
		return areaName;
	}

	public void setAreaName(String areaName) {
		this.areaName = areaName;
	}
}