package com.cku.oa.sampling.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 导出采样包Entity
 *
 * @author yuanshuai
 * @version 2023-05-22
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel
public class SamplingExportVo implements Serializable {

	private static final long serialVersionUID = -4216551686972323470L;
	@ExcelField(title = "采样包编号", align = 2, sort = 1)
	private String samplingCode;
	@ExcelField(title = "犬只编号", align = 2, sort = 2)
	private String dogCode;
	@ExcelField(title = "芯片号", align = 2, sort = 3)
	private String chipCode;
	@ExcelField(title = "归属人会员号", align = 2, sort = 4)
	private String memberCode;
	@ExcelField(title = "归属人", align = 2, sort = 5)
	private String memberName;
	@ExcelField(title = "绑定人会员号", align = 2, sort = 6)
	private String bindMemberCode;
	@ExcelField(title = "绑定人", align = 2, sort = 7)
	private String bindUserName;
	@ExcelField(title = "绑定时间", align = 2, sort = 8)
	private Date bindTime;
	@ExcelField(title = "送检时间", align = 2, sort = 9)
	private Date sendTime;
	@ExcelField(title = "状态", align = 2, sort = 10)
	private String state;
	@ExcelField(title = "备注", align = 2, sort = 11)
	private String remarks;
}