package com.cku.oa.org.vo;

import com.thinkgem.jeesite.common.persistence.Page;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 俱乐部采样包分组列表
 *
 * @author yuanshuai
 * @date 2023/5/28 15:47
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel
public class OrgSamplingDetailListVo implements Serializable {

	// id
	private String id;
	// 批次号
	private String batchNum;
	// 俱乐部id
	private String orgId;
	// 俱乐部名称
	private String orgName;
	// 采样包编号
	private String samplingCode;
	// 犬只编号（证书号、出生纸编号、国外证书号）
	private String dogCode;
	// 芯片号（显示用）
	private String chipCode;
	// 绑定状态（0未绑定，1已绑定）
	private Integer bindType;
	//流程状态（0待邮寄，1已邮寄，2已送检，3检测成功，4检测失败，5已注销）
	private Integer flowState;
	// 发放时间
	private Date postDate;

	//分页
	private Page<OrgSamplingDetailListVo> page;
}
