package com.cku.oa.order.service.impl;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.common.SKUIDConstants;
import com.cku.oa.constant.Constants;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerWrittenExamInfo;
import com.cku.oa.groomer.service.GroomerRegisterService;
import com.cku.oa.groomer.service.GroomerWrittenExamInfoService;
import com.cku.oa.order.service.BaseSkuBusinessService;
import com.cku.oa.order.service.IOrderBusinessService;
import com.cku.oa.order.vo.GroomerWrittenExamResitVo;
import com.cku.oa.order.vo.OrderSkuVo;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.dog.vo.request.GroomerRegisterRequest;
import com.cku.restful.v2.order.vo.request.OrderApplyRequest;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 美容考试处理类
 *
 * @author yuanshuai
 * @date 2023年12月4日17:18:25
 */
@Service
public class GroomerWrittenExamInfoOrderServiceImpl extends BaseSkuBusinessService<GroomerWrittenExamResitVo> implements IOrderBusinessService<GroomerRegisterRequest> {

	@Autowired
	private GroomerRegisterService groomerRegisterService;

	@Autowired
	private GroomerWrittenExamInfoService groomerWrittenExamInfoService;

	@Override
	public void businessValidate(OrderApplyRequest orderRequest, GroomerRegisterRequest businessRequest, Member member) {
		if (StringUtils.isBlank(businessRequest.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空,请检查!");
		}
	}

	@Override
	public List<OrderSkuVo> preOrder(OrderApplyRequest orderRequest, GroomerRegisterRequest businessRequest, Member member) {
		//sku列表
		List<OrderSkuVo> skuVoList = Lists.newArrayList();
		//添加证书费SKU
		skuVoList.add(OrderSkuVo.builder()
				.skuId(SKUIDConstants.GROOMER_WRITTEN_EXAM_INFO_RE)
				.num(1)
				.businessList(Stream.of(GroomerWrittenExamResitVo.builder()
								.registerId(businessRequest.getId()).build())
							.collect(Collectors.toList()))
				.build());
		return skuVoList;
	}

	@Override
	@Transactional(readOnly = false)
	public void processBusinessPrePay(OrderApplyRequest orderRequest, GroomerWrittenExamResitVo businessData, OrderSkuVo skuVo) {
		//根据不同业务处理入口
		/*if (SysBusinessIdConstants.GROOMER_EXAM_RESIT.equals(orderRequest.getBusinessID())) {*/
			//处理美容补考
		processBusinessByGroomerWrittenExamResit(businessData, skuVo);
		/*}*/
	}

	/**
	 * 根据金质证书处理业务
	 *
	 * @author yuanshuai
	 * @date 2023/6/20 16:30
	 */
	private void processBusinessByGroomerWrittenExamResit(GroomerWrittenExamResitVo businessData, OrderSkuVo skuVo) {
		GroomerWrittenExamInfo groomerWrittenExamInfo = buildGroomerWrittenExamResitInfo(businessData, skuVo);
		groomerWrittenExamInfoService.save(groomerWrittenExamInfo);
	}

	/**
	 * 根据禁止证书构建DNA亲子比对
	 *
	 * @author yuanshuai
	 * @date 2023/6/20 16:22*/

	private GroomerWrittenExamInfo buildGroomerWrittenExamResitInfo(GroomerWrittenExamResitVo businessData, OrderSkuVo skuVo) {
		GroomerRegister groomerRegister = groomerRegisterService.get(businessData.getRegisterId());
		GroomerWrittenExamInfo groomerWrittenExamInfo = new GroomerWrittenExamInfo();
		groomerWrittenExamInfo.setPaymentState(Constants.STRING_NUM_ONE);
		groomerWrittenExamInfo.setRunningNumber(skuVo.getOrderCode());
		groomerWrittenExamInfo.setShowCode(groomerRegister.getGroomerShow().getShowCode());
		groomerWrittenExamInfo.setRegisterId(groomerRegister.getId());
		groomerWrittenExamInfo.setPaymentMemberCode(skuVo.getMember().getMemberCode());
		groomerWrittenExamInfo.setMemberCode(skuVo.getMember().getMemberCode());
		groomerWrittenExamInfo.setOrderCode(skuVo.getOrderCode());

		return groomerWrittenExamInfo;
	}

}
