package com.cku.oa.kennel.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.oa.finance.dao.PaymentCartDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.dao.KennelOwnerChangeDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.entity.KennelOwnerChange;
import com.cku.oa.sys.entity.user.CardTypeEnum;
import com.cku.oa.sys.entity.user.KennelType;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberCardTypeEnum;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.zalog.SysContext;
import com.github.sd4324530.fastweixin.util.StrUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬舍所有人变更Service
 * 
 * @author zhuguanjin
 * @version 2016-08-23
 */
@Service
@Transactional(readOnly = true)
public class KennelOwnerChangeService extends CrudService<KennelOwnerChangeDao, KennelOwnerChange> {

	@Autowired
	private KennelService kennelService;
	@Autowired
	private PaymentOrderService paymentOrderService;

	@Autowired
	private MemberService memberService;

	@Autowired
	private PaymentCartDao paymentCartDao;

	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	@Autowired
	private KennelDao kennelDao;

	public KennelOwnerChange get(String id) {
		return super.get(id);
	}

	public List<KennelOwnerChange> findList(KennelOwnerChange kennelOwnerChange) {
		return super.findList(kennelOwnerChange);
	}

	public List<KennelOwnerChange> findOriginApplyingChangeList(String memberCode) {
		return this.dao.getOriginApplyingChangeList(memberCode);
	}

	public List<KennelOwnerChange> findNewApplyingChangeList(String memberCode) {
		return this.dao.getNewApplyingChangeList(memberCode);
	}

	public Page<KennelOwnerChange> findPage(Page<KennelOwnerChange> page, KennelOwnerChange kennelOwnerChange) {
		return super.findPage(page, kennelOwnerChange);
	}

	@Transactional(readOnly = false)
	public void save(KennelOwnerChange kennelOwnerChange) {
		super.save(kennelOwnerChange);
	}

	@Transactional(readOnly = false)
	public void delete(KennelOwnerChange kennelOwnerChange) {
		super.delete(kennelOwnerChange);
	}

	@Transactional(readOnly = false)
	public void audit(KennelOwnerChange audit) throws Exception {
		try {
			KennelOwnerChange kennelOwnerChange = get(audit.getId());
			SysContext sysContext = new SysContext(kennelOwnerChange.getPaymentState(),
					kennelOwnerChange.getReviewState(), kennelOwnerChange.getProcessState());
			if ("1".equals(audit.getReviewState())) {
				kennelOwnerChange.setReviewState("1");
				// sysContext.confirmSuccess(sysContext,
				// "犬舍所有人变更审核",kennelOwnerChange.getNewOwnerMemberCode(),"kennel_owner_change",kennelOwnerChange.getId(),kennelOwnerChange.getRunningNumber(),
				// (str)->{});
			} else if ("2".equals(audit.getReviewState())) {
				kennelOwnerChange.setReviewState("2");
				kennelOwnerChange.setReviewRemarks(audit.getReviewRemarks());
				// sysContext.confirmFail(sysContext, "犬舍所有人变更审核", audit.getReviewRemarks(),
				// kennelOwnerChange.getNewOwnerMemberCode(),"kennel_owner_change",kennelOwnerChange.getId(),kennelOwnerChange.getRunningNumber(),
				// (str)->{});
			} else if ("0".equals(audit.getReviewState()) || "3".equals(audit.getReviewState())) {
				kennelOwnerChange.setReviewState(audit.getReviewState());
				// sysContext.noStateExecute(sysContext, "犬舍所有人变更审核",
				// kennelOwnerChange.getNewOwnerMemberCode(),"kennel_owner_change",kennelOwnerChange.getId(),kennelOwnerChange.getRunningNumber(),
				// (str)->{});
			} else {
				throw new Exception("请选择正确的审核状态");
			}
			kennelOwnerChange.setReviewTime(new Date());
			super.save(kennelOwnerChange);
		} catch (Exception e) {
			throw e;
		}
	}

	@Transactional(readOnly = false)
	public void resolve(KennelOwnerChange review) throws Exception {
		try {
			KennelOwnerChange kennelOwnerChange = get(review.getId());
//			SysContext sysContext = new SysContext(kennelOwnerChange.getPaymentState(),kennelOwnerChange.getReviewState(),kennelOwnerChange.getProcessState());
//			sysContext.updateData(sysContext,"犬舍所有人变更处理",kennelOwnerChange.getNewOwnerMemberCode(),"kennel_owner_change",kennelOwnerChange.getId(),kennelOwnerChange.getRunningNumber(), (str)->{});
			kennelOwnerChange.setProcessState("1");
			kennelOwnerChange.setProcessTime(new Date());
			super.save(kennelOwnerChange);
			// 写入犬舍信息表
			insertKennel(kennelOwnerChange);
		} catch (Exception e) {
			throw e;
		}
	}

	@Transactional(readOnly = false)
	public String changeKennel(String kennelOwnerChangeId) {
		return this.insertKennel(dao.get(kennelOwnerChangeId));
	}

	private String insertKennel(KennelOwnerChange kennelOwnerChange) {
		Kennel kennel = kennelService.get(kennelOwnerChange.getKennel().getId());
		// 日期更新
		Member newMember = memberService.getByMemberCode(kennelOwnerChange.getNewOwnerMemberCode());
		Member originMember = memberService.getByMemberCode(kennelOwnerChange.getOriginOwnerMemberCode());
		// 取出最大的日期
		List<Date> list = new ArrayList<>();
		if (!KennelType.permanent.toString().equals(kennel.getType())) {
			list.add(kennel.getEndTime());
		}
		list.add(newMember.getMemberEndDate());
		list.add(originMember.getMemberEndDate());
		Date date = list.stream().max(Date::compareTo).get();
		memberService.updateMemberCardTypeAndEndDate(newMember.getMemberCode(), originMember.getMemberCardType(),
				DateUtils.formatDate(date, null));
		memberService.updateMemberCardTypeAndEndDate(originMember.getMemberCode(),
				MemberCardTypeEnum.GOLDEN_CARD.code(), DateUtils.formatDate(originMember.getMemberEndDate(), null));
		kennel.setPrintState("0");
		kennel.setReviewState("0");
		kennel.setFciPrintState("0");
		kennel.setMemberCode(kennelOwnerChange.getNewOwnerMemberCode());
		kennel.setKennelCode(kennelOwnerChange.getNewOwnerMemberCode());
		if (!KennelType.permanent.toString().equals(kennel.getType())) {
			kennel.setEndTime(date);
		}
		kennelService.update(kennel);
		return kennel.getId();
	}

	/**
	 * 得到已缴费 未审核的犬舍所有人变更申请
	 * 
	 * @Author chaixueteng
	 * @2016年9月6日上午9:56:23
	 */
	public int getOwnerChangeCount() {
		return dao.getOwnerChangeCount();
	}

	@Transactional(readOnly = false)
	public void orderSave(KennelOwnerChange kennelOwnerChange) {
		kennelOwnerChange.setPaymentState("2");
		kennelOwnerChange
				.setPaymentTime(paymentOrderService.getPaymentTimeByOrderCode(kennelOwnerChange.getRunningNumber()));
		kennelOwnerChange.setReviewState("0");
		kennelOwnerChange.setProcessState("0");
		super.save(kennelOwnerChange);
	}

	@Transactional(readOnly = false)
	public Map<String, String> orderSaveNew(KennelOwnerChange kennelOwnerChange) {
		Map<String, String> map = new HashMap<>();
		map.put("code", "0");
		String originMemberCode = kennelOwnerChange.getOriginOwnerMemberCode();
		String newMemberCode = kennelOwnerChange.getNewOwnerMemberCode();
		Member originMember = memberService.getByMemberCode(originMemberCode);
		Member newMember = memberService.getByMemberCode(newMemberCode);
		String loginTypeCurrent = StringUtils.isBlank(originMember.getMemberSite()) ? "2"
				: originMember.getMemberSite();
		String loginTypeNew = StringUtils.isBlank(newMember.getMemberSite()) ? "2" : newMember.getMemberSite();

		
		Kennel k = kennelService.getKennelByMemberCode(originMemberCode);
		if (k == null || "3".equals(k.getReviewState())) {
			map.put("code", "-1");
			map.put("msg", "原犬舍所有人名下无犬舍信息，无法变更！");
			return map;
		}
		if(!k.getKennelCode().equals(kennelOwnerChange.getKennelCode())) {
			map.put("code", "-1");
			map.put("msg", "原犬舍所有人与查询结果不一致，请查询后再提交");
			return map;
		}
		
		// 原犬舍为空
		Kennel kennel = kennelDao.getKennelByMemberCode(originMemberCode);
		if (kennel == null) {
			// throw new ZAException(ZAErrorCode.ZA_ERROR, "该会员名下无犬舍信息，无法变更！");
			map.put("code", "-1");
			map.put("msg", "原犬舍所有人名下无犬舍信息，无法变更！");
			return map;
		}
		// 新犬主不为金卡
		if(StringUtils.isNotEmpty(newMember.getMemberType()) && "foreign".equals(newMember.getMemberType())) {
			map.put("code", "-1");
			map.put("msg", "新犬舍所有人不是金卡会员，无法变更！");
			return map;
		}
		if (UserUtils.getMemberCardType(newMemberCode) != CardTypeEnum.GOLDEN_CARD.code()) {
			map.put("code", "-1");
			map.put("msg", "新犬舍所有人不是金卡会员，无法变更！");
			return map;
		}
		// 已有申请记录
		Kennel newKennel = kennelDao.getKennelByMemberCode(newMemberCode);
		if (newKennel != null && !"3".equals(kennel.getReviewState())) {
			map.put("code", "-1");
			map.put("msg", "新犬舍所有人名下已有犬舍，无法变更！");
			return map;
		}
		// 如原犬舍有变更记录，且状态 非（未通过，已注销），则不允许再次变更
		List<KennelOwnerChange> changeList = this.findOriginApplyingChangeList(originMemberCode);
		if (!CollectionUtils.isEmpty(changeList) && changeList.size() > 0) {
			// throw new ZAException(ZAErrorCode.ZA_ERROR, "原犬舍已有犬舍变更记录，无法变更！");
			map.put("code", "-1");
			map.put("msg", "原犬舍已有犬舍变更记录，无法变更！");
			return map;
		}
		
		
		// 判断申请人当前是否已有犬舍变更申请记录，有则不允许重复申请
		changeList = this.findNewApplyingChangeList(newMemberCode);
		if (!CollectionUtils.isEmpty(changeList) && changeList.size() > 0) {
			// throw new ZAException(ZAErrorCode.ZA_ERROR, "存在处理中的犬舍变更记录，请勿重复申请！");
			map.put("code", "-1");
			map.put("msg", "新犬舍所有人存在处理中的犬舍变更记录，请勿重复申请！");
			return map;
		}
		if (!loginTypeCurrent.equals(loginTypeNew)) {
			map.put("code", "-1");
			map.put("msg", "原犬舍所有人犬舍类型和新犬舍所有人类型不属于同一俱乐部，无法变更！");
			return map;
		}
		// 匹配收费项
		PaymentChargingItem pci = paymentChargingItemService.get(kennelOwnerChange.getChargingItemId());
		if (pci.getName().contains("年度") && !originMember.getKennel().getType().equals("year")) {
			map.put("code", "-1");
			map.put("msg", "原犬舍非年度犬舍,无法变更!");
			return map;
		}
		if (pci.getName().contains("永久") && !originMember.getKennel().getType().equals("permanent")) {
			map.put("code", "-1");
			map.put("msg", "原犬舍非永久犬舍,无法变更!");
			return map;
		}
		KennelOwnerChange obj = new KennelOwnerChange();
		obj.setNewOwnerMemberCode(newMemberCode);
		List<KennelOwnerChange> lists = this.findList(kennelOwnerChange);
		for (KennelOwnerChange e : lists) {
			if ("2".equals(e.getPaymentState())) {
				if (("0".equals(e.getReviewState()))
						|| ("1".equals(e.getReviewState()) && "0".equals(e.getProcessState()))) {
//					throw new Exception("您已申请犬舍所有人变更，正在审核处理中！");
					map.put("code", "-1");
					map.put("msg", "新犬舍所有人已申请犬舍所有人变更，正在审核处理中！");
					return map;
				}
			} else {
				if (StrUtil.isNotBlank(e.getRunningNumber())) {
					// 查订单
					PaymentOrder order = paymentOrderService.get(e.getRunningNumber());
					// 如果订单已删除。报错提示
					if (order != null && "0".equals(order.getDelFlag())) {
						// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您已申请犬舍所有人变更,有未支付订单。");
						map.put("code", "-1");
						map.put("msg", "新犬舍所有人已申请犬舍所有人变更,有未支付订单。");
						return map;
					}
				} else {
					// 查购物车
					PaymentCart paymentCart = paymentCartDao.getByTableAndId("kennel_owner_change", e.getId());
					if (paymentCart != null) {
						// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						// "您已申请犬舍所有人变更,购物车中有未支付订单！。");
						map.put("code", "-1");
						map.put("msg", "新犬舍所有人申请犬舍所有人变更,购物车中有未支付订单！。");
						return map;
					}
				}
			}
		}

		kennelOwnerChange.setPaymentState("2");
		kennelOwnerChange
				.setPaymentTime(paymentOrderService.getPaymentTimeByOrderCode(kennelOwnerChange.getRunningNumber()));
		kennelOwnerChange.setReviewState("0");
		kennelOwnerChange.setProcessState("0");
		super.save(kennelOwnerChange);
		return map;
	}

	/**
	 * 根据会员号的到犬舍信息
	 * 
	 * @Author chaixueteng
	 * @2016年9月27日下午6:10:47
	 */
	public Map<String, String> getKennelName(String originOwnerMemberCode) {
		Map<String, String> map = new HashMap<String, String>();
		Kennel k = kennelService.getKennelByMemberCode(originOwnerMemberCode);
		if (k == null || "3".equals(k.getReviewState())) {
			map.put("code", "-1");
			map.put("msg", "原犬舍所有人名下无犬舍信息，无法变更！");
			return map;
		}
		map.put("code", "0");
		map.put("kennelName", k.getName());
		map.put("kennelCode", k.getKennelCode());
		map.put("kennelType", k.getType());
		return map;
	}

}