/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.handler.entity.HandlerDiploma;
import com.cku.oa.handler.service.HandlerDiplomaService;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 结业证书Controller
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Controller
@RequestMapping(value = "${adminPath}/handler/handlerDiploma")
public class HandlerDiplomaController extends BaseController {

	@Autowired
	private HandlerDiplomaService handlerDiplomaService;
	
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	
	@ModelAttribute
	public HandlerDiploma get(@RequestParam(required=false) String id) {
		HandlerDiploma entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = handlerDiplomaService.get(id);
			entity.setSchoolNameCn(StringEscapeUtils.unescapeHtml(entity.getSchoolNameCn()));
			entity.setSchoolNameEn(StringEscapeUtils.unescapeHtml(entity.getSchoolNameEn()));
		}
		if (entity == null){
			entity = new HandlerDiploma();
		}
		return entity;
	}
	
	@RequiresPermissions("handler:handlerDiploma:view")
	@RequestMapping(value = {"list", ""})
	public String list(HandlerDiploma handlerDiploma, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<HandlerDiploma> page = handlerDiplomaService.findPage(new Page<HandlerDiploma>(request, response),handlerDiploma);
		page.getList().forEach(h->{
			h.setSchoolNameCn(StringEscapeUtils.unescapeHtml(h.getSchoolNameCn()));
			h.setSchoolNameEn(StringEscapeUtils.unescapeHtml(h.getSchoolNameEn()));
		});
		
		model.addAttribute("page", page);
		return "oa/handler/handlerDiplomaList";
	}
	
	@RequiresPermissions("handler:handlerDiploma:view")
	@RequestMapping(value = "form")
	public String form(HandlerDiploma handlerDiploma, Model model) {
		model.addAttribute("handlerDiploma", handlerDiploma);
		return "oa/handler/handlerDiplomaForm";
	}
	
	@RequiresPermissions("handler:handlerDiploma:view")
	@RequestMapping(value = "addForm")
	public String addForm(HandlerDiploma handlerDiploma, Model model) {
		TrainingInstitution ti = new TrainingInstitution();
		List<TrainingInstitution> findList = trainingInstitutionDao.findHandlerList(ti);
		model.addAttribute("findList", findList);
		model.addAttribute("handlerDiploma", handlerDiploma);
		return "oa/handler/handlerDiplomaAdd";
	}
	
	@RequiresPermissions("handler:handlerDiploma:view")
	@RequestMapping(value = "handlerView")
	public String handlerView(HandlerDiploma handlerDiploma, Model model) {
		model.addAttribute("handlerDiploma", handlerDiploma);
		return "oa/handler/handlerDiplomaView";
	}
	
	@RequiresPermissions("handler:handlerDiploma:edit")
	@RequestMapping(value = "save")
	public String save(HandlerDiploma handlerDiploma, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, handlerDiploma)){
			return form(handlerDiploma, model);
		}
		handlerDiplomaService.save(handlerDiploma);
		addMessage(redirectAttributes, "保存结业证书成功");
		return "redirect:"+Global.getAdminPath()+"/handler/handlerDiploma/?repage";
	}
	
	@RequiresPermissions("handler:handlerDiploma:edit")
	@RequestMapping(value = "delete")
	public String delete(HandlerDiploma handlerDiploma, RedirectAttributes redirectAttributes) {
		handlerDiplomaService.delete(handlerDiploma);
		addMessage(redirectAttributes, "删除结业证书成功");
		return "redirect:"+Global.getAdminPath()+"/handler/handlerDiploma/?repage";
	}
	
	/**
	 * 审核页
	 * @Author chaixueteng
	 * @2016年8月9日上午10:35:43
	 */
	@RequiresPermissions("handler:handlerDiploma:audit")
	@RequestMapping(value = "review")
	public String review(HandlerDiploma handlerDiploma, Model model) throws Exception{
		model.addAttribute("handlerDiploma", handlerDiploma);
		return "oa/handler/handlerDiplomaAudit";
	}
	/**
	 * 审核  单条
	 * @Author chaixueteng
	 * @2016年9月3日上午11:35:22
	 */
	@RequestMapping(value = "reviewSave")
	public String reviewSave(HandlerDiploma handlerDiploma,RedirectAttributes redirectAttributes) throws Exception{
		try {
			handlerDiplomaService.review(handlerDiploma);
		} catch (Exception e) {
			addMessage(redirectAttributes,e.getMessage());
			return "redirect:"+Global.getAdminPath()+"/handler/handlerDiploma/review?id="+handlerDiploma.getId();
		}
		return "redirect:"+Global.getAdminPath()+"/handler/handlerDiploma/?repage";
	}
	
	/**
	 * 生成证书号和签发日期 批量
	 * @Author chaixueteng
	 * @2016年8月9日上午10:43:04
	 */
	@RequiresPermissions("handler:handlerDiploma:create")
	@RequestMapping("createCode")
	@ResponseBody
	public Object createCode(HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttributes){
		Map<String,Object> map=new HashMap<String,Object>();
		map.put("rc", "0");
		String id=request.getParameter("id");
		try {
			handlerDiplomaService.createCode(id);
		} catch (Exception e) {
			map.put("rc", "1");
        	map.put("msg", e.getMessage());
		}
		return map;
	}
	/**
	 * 生成证书号和签发日期 单个
	 * @Author chaixueteng
	 * @2016年8月9日上午10:43:04
	 */
	@RequiresPermissions("handler:handlerDiploma:create")
	@RequestMapping("createCodeOne")
	public String createCodeOne(String id,HttpServletRequest request, HttpServletResponse response){
		handlerDiplomaService.createCode(id);
		return "redirect:"+Global.getAdminPath()+"/handler/handlerDiploma/?repage";
	}
	/**
	 * 批量审核通过
	 * @Author chaixueteng
	 * @2016年8月15日上午10:39:48
	 */
	@RequiresPermissions("handler:handlerDiploma:audit")
	@RequestMapping("listSubmit")
	@ResponseBody
	public Object listSubmit(HttpServletRequest request, HttpServletResponse response,RedirectAttributes redirectAttributes){
		Map<String,Object> map=new HashMap<String,Object>();
		map.put("rc", "0");
		String id = request.getParameter("id");
		try {
			handlerDiplomaService.listSubmit(id);
		} catch (Exception e) {
			map.put("rc", "1");
        	map.put("msg", e.getMessage());
		}
		return map;
	}
	
	/**
	 * 培训结业证书导出
	 * @Author chaixueteng
	 * @2016年8月3日下午4:48:21
	 */
	@RequiresPermissions("handler:handlerDiploma:export")
    @RequestMapping(value = "export")
    public String export(HandlerDiploma handlerDiploma,HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			handlerDiplomaService.export(handlerDiploma,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出报名信息失败！失败信息："+e.getMessage());
		}
		return null;
    }
	
	/**
	 * 结业证书打印
	 * @Author chaixueteng
	 * @2016年8月22日下午5:47:16
	 */
	@RequiresPermissions("handler:handlerDiploma:print")
	@RequestMapping(value = "handlerDiplomaPrint")
	public String handlerDiplomaPrint(HandlerDiploma handlerDiploma, HttpServletRequest request, HttpServletResponse response, Model model) {
		HandlerDiploma hd=handlerDiplomaService.print(handlerDiploma);
		model.addAttribute("handlerDiploma", hd);
        return "oa/handler/handlerDiplomaPrint";
    }
	/**
	 * 重置打印
	 * @Author chaixueteng
	 * @2016年8月22日下午5:47:58
	 */
	@RequiresPermissions("handler:handlerDiploma:resetPrint")
	@RequestMapping(value = "resetPrint")
	public String resetPrint(String id, RedirectAttributes redirectAttributes){
		handlerDiplomaService.resetPrint(id);
		return "redirect:"+Global.getAdminPath()+"/handler/handlerDiploma/?repage";
	}
}