package com.cku.oa.groomer.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;

import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.dao.GroomerShowBreedsDao;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerShowBreeds;
import com.cku.oa.groomer.vo.GroomerShowBreedsGroupVO;
import com.cku.oa.sys.util.FnsUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

import edu.emory.mathcs.backport.java.util.Arrays;

/**
 * 美容活动犬种Service
 * 
 * @author Sunny
 * @version 2021-12-17
 */
@Service
@Transactional(readOnly = true)
public class GroomerShowBreedsService extends CrudService<GroomerShowBreedsDao, GroomerShowBreeds> {

	@Autowired
	private GroomerQualificationCertificateDao groomerQualificationCertificateDao;

	public GroomerShowBreeds get(String id) {
		return super.get(id);
	}

	public List<GroomerShowBreeds> findList(GroomerShowBreeds groomerShowBreeds) {
		return super.findList(groomerShowBreeds);
	}

	public Page<GroomerShowBreeds> findPage(Page<GroomerShowBreeds> page, GroomerShowBreeds groomerShowBreeds) {
		return super.findPage(page, groomerShowBreeds);
	}

	@Transactional(readOnly = false)
	public void save(GroomerShowBreeds groomerShowBreeds) {
		super.save(groomerShowBreeds);
	}

	@Transactional(readOnly = false)
	public void delete(GroomerShowBreeds groomerShowBreeds) {
		super.delete(groomerShowBreeds);
	}

	/**
	 * 查询会员取得证书的洗护师报名信息
	 * 
	 * @param memberCode
	 * @return
	 */
	public List<GroomerRegister> findNurseGroomerShowRegister(String memberCode) {
		if (StringUtils.isBlank(memberCode)) {
			return Collections.emptyList();
		}
		return groomerQualificationCertificateDao.findNurseRegisterList(memberCode);
	}

	/**
	 * 查询洗护师报名可选犬种分组列表
	 * 
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public List<GroomerShowBreedsGroupVO> findNurseGroomerShowBreeds(GroomerShowBreeds request) {
		if (StringUtils.isBlank(request.getShowLevels()) || StringUtils.isBlank(request.getMemberCode())) {
			return Collections.emptyList();
		}
		List<GroomerShowBreedsGroupVO> resultList = new ArrayList<>();
		Set<String> registerBreedsSet = new HashSet<>();
		// 查询会员取得证书的洗护师报名信息
		List<GroomerRegister> registerList = groomerQualificationCertificateDao
				.findNurseRegisterList(request.getMemberCode());
		// 将所有报名犬种按逗号分隔组成Set（过滤重复）
		if (!CollectionUtils.isEmpty(registerList)) {
			for (GroomerRegister r : registerList) {
				registerBreedsSet.addAll(Arrays.asList(r.getShowDogBreed().split(",")));
			}
		}
		// 查询可选择犬种集合
		List<GroomerShowBreeds> showBreedList = this
				.findList(GroomerShowBreeds.builder().showLevels(request.getShowLevels()).build());
		if (!CollectionUtils.isEmpty(showBreedList)) {
			Map<String, List<GroomerShowBreeds>> breedMap = showBreedList.stream().map(b -> {
				b.setRegistered(registerBreedsSet.contains(b.getBreedName()));
				return b;
			}).collect(Collectors.groupingBy(GroomerShowBreeds::getBreedGroup));
			breedMap.forEach((key, val) -> {
				resultList.add(GroomerShowBreedsGroupVO.builder().breedGroup(key).breedList(val).build());
			});
			FnsUtils.sortGroupList(resultList);
		}
		return resultList;
	}

	public String getGroomerShowBreeds(GroomerShowBreeds groomerShowBreeds, Model model) {
		List<GroomerShowBreedsGroupVO> breedGroupList = this.findNurseGroomerShowBreeds(groomerShowBreeds);
		int maxNum = getShowLevelMaxNum(groomerShowBreeds.getShowLevels());
		int minNum = maxNum;
		if(Objects.nonNull(groomerShowBreeds.getValidate()) && !groomerShowBreeds.getValidate()) {
			minNum = 1;
			maxNum = 20;
		}else {
			List<GroomerShowBreeds> registerdList = new ArrayList<>();
			breedGroupList.forEach(v -> {
				registerdList.addAll(v.getBreedList().stream().filter(b -> b.isRegistered()).collect(Collectors.toList()));
			});
			minNum = maxNum - registerdList.size();
			minNum = minNum < 1 ? 1 : minNum;
		}
		model.addAttribute("minNum", minNum);
		model.addAttribute("maxNum", maxNum);
		model.addAttribute("showLevelsLabel",
				DictUtils.getDictLabel(groomerShowBreeds.getShowLevels(), "groomer_nurse_level", ""));
		model.addAttribute("showLevel", groomerShowBreeds.getShowLevels());
		model.addAttribute("checkedBreeds", groomerShowBreeds.getCheckedBreeds());
		model.addAttribute("otherBreeds", groomerShowBreeds.getOtherBreeds());
		model.addAttribute("validate", groomerShowBreeds.getValidate());
		model.addAttribute("breedGroupList", breedGroupList);

		return "oa/groomer/groomerShowBreedsSelect";
	}

	public int getShowLevelMaxNum(String showLevel) {
		int maxNum = 1;
		switch (showLevel) {
		case "PRIMARY":
			maxNum = 1;
			break;
		case "SENIOR":
			maxNum = 3;
			break;
		case "MATCH":
			maxNum = 5;
			break;
		}
		return maxNum;
	}

}