/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.dao;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.groomer.entity.GroomerCourseApplication;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

import java.util.List;

/**
 * 美容课程报名表DAO接口
 *
 * @author xx
 * @version 2020-09-21
 */
@MyBatisDao
public interface GroomerCourseApplicationDao extends CrudDao<GroomerCourseApplication> {
	GroomerCourseApplication getOneByMemberCodeACourseId(@Param("memberCode") String memberCode,
			@Param("courseId") String courseId);

    List<GroomerCourseApplication> findByMemberCode(@Param("memberCode")String memberCode);

    int countByCourseId(@Param("courseId") String courseId);
}