/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.dao;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.finance.entity.SaPaymentDetailTotal;
import com.cku.oa.finance.vo.SaPaymentWayAccountVo;
import com.cku.oa.finance.vo.SaVoucherFinishedOrderVo;
import com.cku.oa.finance.vo.SaVoucherRechargeVo;
import com.cku.oa.finance.vo.SaVoucherRefundVo;
import com.cku.oa.finance.vo.SaVoucherTransferAccountVo;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 充值消费明细DAO接口
 *
 * @author wangjie
 * @version 2019-08-29
 */
@MyBatisDao
public interface SaPaymentDetailTotalDao extends CrudDao<SaPaymentDetailTotal> {

	String getAllUncompletedIncome();

	int listCount(SaPaymentDetailTotal saPaymentDetailTotal);

	List<SaPaymentDetailTotal> getByRunningNumber(@Param("runningNumber") String runningNumber);

	SaPaymentDetailTotal getOneByRunningNumber(@Param("runningNumber") String runningNumber);

	int updateReceive(SaPaymentDetailTotal saPaymentDetailTotal);

	int updatePayment(SaPaymentDetailTotal saPaymentDetailTotal);

	List<SaPaymentDetailTotal> getResult(@Param("runningNumber") String runningNumber);

	List<SaPaymentDetailTotal> listByRecordIds(@Param("recordIds") List<String> recordIds);

	Integer countByOrderId(@Param("orderId") String orderId);

    int financeConfirmTime(@Param("detailId") String detailId);

    List<SaPaymentWayAccountVo> findAllPaymentWayAccounts();

    List<SaVoucherRechargeVo> findRechargeVoucherData(@Param("startDate")String startDate,@Param("endDate")String endDate);

    List<SaVoucherRefundVo> findRefundOrderVoucherData(@Param("startDate")String startDate,@Param("endDate")String endDate);
    
    List<SaVoucherFinishedOrderVo> findFinishedOrderVoucherData(@Param("startDate")String startDate,@Param("endDate")String endDate);

	List<SaVoucherTransferAccountVo> findTransferVoucherData(@Param("startDate")String startDate,@Param("endDate")String endDate);
    
    int financeConfirmTime(SaPaymentDetailTotal total);

	List<SaPaymentDetailTotal> listByOrderIds(@Param("detailIds") List<String> detailIds);

	List<SaPaymentDetailTotal> findByIdSet(@Param("chargeItemIdArray")String[] chargeItemIdArray,
											 @Param("chargeDate")String chargeDate,@Param("paymentTime")String  paymentTime);

	int updateRevenueRecognition(@Param("id") String id, @Param("date")Date date);
	
	int financeConfirmNum(SaPaymentDetailTotal total);
	
	SaPaymentDetailTotal findEntityByOrderId(SaPaymentDetailTotal total);
	
	List<SaPaymentDetailTotal> getByOldRunningNumber(@Param("oldRunningNumber") String oldRunningNumber);
	
}