/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.finance.entity.PaymentChargingItem;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 收费项目DAO接口
 * 
 * @author lyy
 * @version 2016-07-21
 */
@MyBatisDao
public interface PaymentChargingItemDao extends CrudDao<PaymentChargingItem> {
	PaymentChargingItem getByShortName(String shortName);

	List<PaymentChargingItem> findListByDeptCode(@Param("code") String code);

	List<PaymentChargingItem> findListByIds(@Param("ids") List<String> ids);

	List<PaymentChargingItem> findTypeList(@Param("type") String type);

	List<PaymentChargingItem> getFeesAndCharges();

	/**
	 * @Description：根据收费项目名称获取收费项目编号
	 * @author: zhuoHeng
	 * @version: 2016年7月25日 下午3:48:57
	 */
	PaymentChargingItem getPaymentCode(String name);

	/**
	 * @description: 根据收费项目shortName前缀查询
	 * @author: laiguanglong
	 * @date: 2016年7月29日 下午2:20:06
	 */
	List<PaymentChargingItem> getByShortNamePrefix(String shortName);

	Map getTableByJumpUrl(String jumpUrl);

	List<PaymentChargingItem> getNegativeItems();

	/**
	 * 获取会员繁殖优惠券对应收费项
	 * @author yuanshuai
	 * @date 2021/5/25 10:43
	 */
	List<PaymentChargingItem> getMemberDogCouponItems();

	PaymentChargingItem selectByShortName(@Param("shortName") String shortName);

	List<PaymentChargingItem> findRefundItemList();

	/**
	 * 根据skuId获取列表
	 * @author yuanshuai
	 * @date 2023/6/19 11:38
	 */
    List<PaymentChargingItem> findListBySkuId(@Param("skuId")String skuId);
    
    
    List<PaymentChargingItem> findListByShortNames(@Param("shortNames") List<String> shortNames);
}