package com.cku.oa.dog.web;

import com.cku.core.RESTResponse;
import com.cku.oa.dog.entity.*;
import com.cku.oa.dog.service.*;
import com.cku.oa.dog.vo.DogChipVO;
import com.cku.oa.dog.vo.DogDnaArchiveVO;
import com.cku.oa.finance.vo.PaymentOrderDetailQueryVO;
import com.cku.restful.v1.dog.service.RestDogStickerApplyService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 犬只激活Controller
 *
 * @author lgl
 * @version 2018-06-12
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dogActivation")
public class DogActivationController extends BaseController {

    @Autowired
    private RestDogStickerApplyService restDogStickerApplyService;
    @Autowired
    private DogActivationService dogActivationService;
    @Autowired
    private DogBirthCertificateService dogBirthCertificateService;
    @Autowired
    private DogColorMarkService dogColorMarkService;
    @Autowired
    private DogTypeService dogTypeService;
    @Autowired
    private DogStickerApplyService dogStickerApplyService;
    private static final String REPAGE = "redirect:" + Global.getAdminPath() + "/dog/dogActivation/?repage";
//
    private static final String AUTHORITY_PRDFIX = "dog:dogActivation:";
//
    @ModelAttribute
    public DogActivation get(@RequestParam(required = false) String id) {
        DogActivation entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = dogActivationService.get(id);
        }
        if (entity == null) {
            entity = new DogActivation();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = {"list", ""})
    public String list(DogActivation dogActivation, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<DogActivation> page = dogActivationService.findPage(new Page<>(request, response), dogActivation);
        model.addAttribute("page", page);
        return "oa/dog/dogactivation/dogActivationList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "view")
    @RequestMapping(value = "form")
    public String form(DogActivation dogActivation, Model model) {
        model.addAttribute("dogActivation", dogActivation);
        return "oa/dog/dogactivation/dogActivationForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX + "audit")
    @RequestMapping(value = "audit")
    public String audit(DogActivation dogActivation, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, dogActivation)) {
            return form(dogActivation, model);
        }
        dogActivationService.save(dogActivation);
        addMessage(redirectAttributes, "审核犬只激活成功");
        return REPAGE;
    }

    /**
     * 照片审核
     * @param model
     * @param redirectAttributes
     * @param request
     * @param response
     * @return
     */
    //    @RequiresPermissions(AUTHORITY_PRDFIX + "review")
    @RequestMapping(value = "review")
    public String review( Model model, RedirectAttributes redirectAttributes, HttpServletRequest request, HttpServletResponse response) {
        String id = request.getParameter("id");
        DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.get(id);
        DogActivation dogActivation = dogActivationService.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
        dogBirthCertificate.setColorFlag(dogColorMarkService.getByDogColorMarkCode(dogBirthCertificate.getColorFlag()).getDogColorMarkCn());
        DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
		String dogBreedCnName = dogType == null ? "" : dogType.getBreedCnName();
		dogBirthCertificate.setDogBreedCnName(dogBreedCnName);
        if(dogActivation != null){
            String lifePic = dogActivation.getLifePic();
            if(StringUtils.isNotBlank(lifePic)){
                String[] split = lifePic.split(",");
                model.addAttribute("pictures",split);
            }
        }
        model.addAttribute("dogBirthCertificate", dogBirthCertificate);
		model.addAttribute("dogActivation", dogActivation);
        return "oa/dog/dogactivation/dogActivitionEditForm";
    }

    /**
     * 激活审核
     * @param model
     * @param redirectAttributes
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "saveReview")
    public String saveReview( Model model, RedirectAttributes redirectAttributes, HttpServletRequest request, HttpServletResponse response) {
        String frontPicReviewState = request.getParameter("frontPicReviewState");
        String sidePicReviewState = request.getParameter("sidePicReviewState");
        String backPicReviewState = request.getParameter("backPicReviewState");
        String[] lifePic = request.getParameterValues("lifePic");
        String[] sidePicRemark = request.getParameterValues("sidePicRemark");
        String[] frontPicRemark = request.getParameterValues("frontPicRemark");
        String[] backPicRemark = request.getParameterValues("backPicRemark");
        String id = request.getParameter("dogActivationId");
        String type = request.getParameter("type");
        dogActivationService.saveReview(id,frontPicReviewState,sidePicReviewState,backPicReviewState,frontPicRemark,sidePicRemark,backPicRemark,lifePic);
        dogActivationService.sendReviewMsg(id);
        return "redirect:"+ Global.getAdminPath()+"/birthcertificate/dogBirthCertificate/?repage";
    }

    /**
     *
     * @Description：犬只激活订单业务添加页
     * @author: zhangxiang
     * @version: 2020年04月22日 下午5:23:16
     */
    @RequestMapping(value = "orderAdd")
    public String orderAdd(Dog dog, Model model, @RequestParam(required = true) String chargingItemId,
                           @RequestParam(required = true) String runningNumber,@RequestParam(required = true) String memberCode,@RequestParam(required = true) String id) {
        model.addAttribute("dog", dog);
        model.addAttribute("chargingItemId", chargingItemId);
        model.addAttribute("runningNumber", runningNumber);
        model.addAttribute("memberCode", memberCode);
        model.addAttribute("id", id);
        // TODO 验证是否存在流水号
        return "oa/dog/dogactivation/dogActivationOrderAdd";
    }

    @RequestMapping(value = "/checkByKey", method = RequestMethod.GET)
    public void checkByKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RESTResponse result = new RESTResponse();
            try{
                result = restDogStickerApplyService.checkByKey(request);
            }catch (Exception e){
                result.setRc(1);
                result.setMsg(e.getMessage());
            }
        ServletUtils.writeResponse(response, result);
    }
    /**
     *
     * @author: zhangxiang
     * @version: 2020年04月22日 下午5:23:16
     */
    @RequiresPermissions("dogownerchange:dogOwnerChange:view")
    @RequestMapping(value = { "orderList" })
    public String orderList(DogStickerApply dogStickerApply, HttpServletRequest request, HttpServletResponse response, Model model) {
        List<DogStickerApply> list = new ArrayList<>();
        //查询订单
        if(StringUtils.isNotBlank(dogStickerApply.getId())){
            list = dogStickerApplyService.findList(dogStickerApply);
            for(DogStickerApply l : list){
                l.setApplyClass(dogStickerApplyService.getStickerClass(l.getApplyClass()));
            }

        }
        model.addAttribute("list", list);
        return "oa/dog/dogactivation/dogActivationOrderList";
    }
}