package com.cku.oa.dog.service;

import com.cku.oa.dog.dao.DogNoseMockDao;
import com.cku.oa.dog.entity.DogNoseMock;
import com.cku.restful.v1.open.request.DogNoseMockAddRequest;
import com.cku.restful.v1.open.request.DogNoseMockPageRequest;
import com.cku.restful.v1.open.response.DogNoseMockResp;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 鼻纹模拟Service
 * @author yuanshuai
 * @version 2023-08-14
 */
@Service
@Transactional(readOnly = true)
public class DogNoseMockService extends CrudService<DogNoseMockDao, DogNoseMock> {

	public DogNoseMock get(String id) {
		return super.get(id);
	}
	
	public List<DogNoseMock> findList(DogNoseMock dogNoseMock) {
		return super.findList(dogNoseMock);
	}
	
	public Page<DogNoseMock> findPage(Page<DogNoseMock> page, DogNoseMock dogNoseMock) {
		return super.findPage(page, dogNoseMock);
	}
	
	public Page<DogNoseMockResp> findPage(DogNoseMockPageRequest request) {
		Page<DogNoseMockResp> page = new Page<>(request);
		List<DogNoseMockResp> list = dao.findPage(request);
		page.setList(list);
		page.setCount(request.getCount());
		return page;
	}

	/**
	 * 查找随机3条
	 * @author yuanshuai
	 * @date 2023/8/14 16:11
	 */
	public List<DogNoseMock> findRandomThree() {
		return dao.findRandomThree();
	}

	@Transactional(readOnly = false)
	public void save(DogNoseMock dogNoseMock) {
		super.save(dogNoseMock);
	}

	@Transactional(readOnly = false)
	public void delete(DogNoseMock dogNoseMock) {
		super.delete(dogNoseMock);
	}


	/**
	 * 添加
	 * @author yuanshuai
	 * @date 2023/8/14 16:13
	 */
	@Transactional(readOnly = false)
	public void add(DogNoseMockAddRequest request) {
		DogNoseMock dogNoseMock = new DogNoseMock();
		dogNoseMock.setPedigreeCertified(request.getPedigreeCertified());
		dogNoseMock.setChipCode(request.getChipCode());
		dogNoseMock.setNameEn(request.getNameEn());
		dogNoseMock.setDogBreed(request.getDogBreed());
		dogNoseMock.setNoseCode(request.getNoseCode());
		save(dogNoseMock);
	}
}