/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.List;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬只种类Entity
 * @author zhuoHeng
 * @version 2016-07-21
 */
public class DogType extends DataEntity<DogType> {
	
	private static final long serialVersionUID = 1L;
	private String dogBreedCode;		// 犬种类代码
	private String breedEnName;		// 犬种类英文名称
	private String breedEnAlias;		// breed_en_alias
	private String breedCnName;		// 犬种类中文名称
	private String breedCnAlias;		// 犬种类中文别名
	private String dogBreed;		// 犬种
	private String countries;		// 国别
	private String cacib;		// CACIB
	private String standardTime;		// 标准时间
	private String typeGroup;		// 组
	private String breedClass;		// FCI正式品种:formal、FCI临时认可品种:temp、FCI国家级认可品种:country、FCI不认可品种:unauth
	private String node;		// 节
	private String figures;		// 位
	private String dogBreedPhoto;		// 犬种类照片
	private String nowMaxNumber;		// 当前最大序号
	private String breedCertifiedNumber;		// 繁育证书序号
	private String dnaRegisterNumber;		// DNA登记序号
	private String hdCertifiedNumber;		// HD证书序号
	private String shortName;		// 犬种简称
	private String hot;		// 是否热门标识
	private String dogColor;		// 犬种颜色
	private String batchMaxNum;		// 申请出生纸一窝最大数量
	private String fciFlag;		// 是否FCI承认犬种：0否；1是；

	private String memberCodeFlag; // 查询使用 1:cku 2:dc 3:mc
	
	private List<String> breedClassList; // 包含的fci级别
	
	
	public List<String> getBreedClassList() {
		return breedClassList;
	}

	public void setBreedClassList(List<String> breedClassList) {
		this.breedClassList = breedClassList;
	}

	public DogType() {
		super();
	}

	public DogType(String id){
		super(id);
	}

	@Length(min=0, max=64, message="犬种类代码长度必须介于 0 和 64 之间")
	public String getDogBreedCode() {
		return dogBreedCode;
	}

	public void setDogBreedCode(String dogBreedCode) {
		this.dogBreedCode = dogBreedCode;
	}
	
	@Length(min=0, max=255, message="犬种类英文名称长度必须介于 0 和 255 之间")
	public String getBreedEnName() {
		return breedEnName;
	}

	public void setBreedEnName(String breedEnName) {
		this.breedEnName = breedEnName;
	}
	
	@Length(min=0, max=255, message="breed_en_alias长度必须介于 0 和 255 之间")
	public String getBreedEnAlias() {
		return breedEnAlias;
	}

	public void setBreedEnAlias(String breedEnAlias) {
		this.breedEnAlias = breedEnAlias;
	}
	
	@Length(min=0, max=255, message="犬种类中文名称长度必须介于 0 和 255 之间")
	public String getBreedCnName() {
		return breedCnName;
	}

	public void setBreedCnName(String breedCnName) {
		this.breedCnName = breedCnName;
	}
	
	@Length(min=0, max=255, message="犬种类中文别名长度必须介于 0 和 255 之间")
	public String getBreedCnAlias() {
		return breedCnAlias;
	}

	public void setBreedCnAlias(String breedCnAlias) {
		this.breedCnAlias = breedCnAlias;
	}
	
	@Length(min=0, max=255, message="犬种长度必须介于 0 和 255 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}
	
	@Length(min=0, max=255, message="国别长度必须介于 0 和 255 之间")
	public String getCountries() {
		return countries;
	}

	public void setCountries(String countries) {
		this.countries = countries;
	}
	
	@Length(min=0, max=1, message="CACIB长度必须介于 0 和 1 之间")
	public String getCacib() {
		return cacib;
	}

	public void setCacib(String cacib) {
		this.cacib = cacib;
	}
	
	@Length(min=0, max=100, message="标准时间长度必须介于 0 和 100 之间")
	public String getStandardTime() {
		return standardTime;
	}

	public void setStandardTime(String standardTime) {
		this.standardTime = standardTime;
	}
	
	@Length(min=0, max=50, message="组长度必须介于 0 和 50 之间")
	public String getTypeGroup() {
		return typeGroup;
	}

	public void setTypeGroup(String typeGroup) {
		this.typeGroup = typeGroup;
	}
	
	public String getBreedClass() {
		return breedClass;
	}

	public void setBreedClass(String breedClass) {
		this.breedClass = breedClass;
	}

	@Length(min=0, max=50, message="节长度必须介于 0 和 50 之间")
	public String getNode() {
		return node;
	}

	public void setNode(String node) {
		this.node = node;
	}
	
	@Length(min=0, max=50, message="位长度必须介于 0 和 50 之间")
	public String getFigures() {
		return figures;
	}

	public void setFigures(String figures) {
		this.figures = figures;
	}
	
	@Length(min=0, max=255, message="犬种类照片长度必须介于 0 和 255 之间")
	public String getDogBreedPhoto() {
		return dogBreedPhoto;
	}

	public void setDogBreedPhoto(String dogBreedPhoto) {
		this.dogBreedPhoto = dogBreedPhoto;
	}
	
	@Length(min=0, max=11, message="当前最大序号长度必须介于 0 和 11 之间")
	public String getNowMaxNumber() {
		return nowMaxNumber;
	}

	public void setNowMaxNumber(String nowMaxNumber) {
		this.nowMaxNumber = nowMaxNumber;
	}
	
	@Length(min=0, max=11, message="繁育证书序号长度必须介于 0 和 11 之间")
	public String getBreedCertifiedNumber() {
		return breedCertifiedNumber;
	}

	public void setBreedCertifiedNumber(String breedCertifiedNumber) {
		this.breedCertifiedNumber = breedCertifiedNumber;
	}
	
	@Length(min=0, max=11, message="DNA登记序号长度必须介于 0 和 11 之间")
	public String getDnaRegisterNumber() {
		return dnaRegisterNumber;
	}

	public void setDnaRegisterNumber(String dnaRegisterNumber) {
		this.dnaRegisterNumber = dnaRegisterNumber;
	}
	
	@Length(min=0, max=11, message="HD证书序号长度必须介于 0 和 11 之间")
	public String getHdCertifiedNumber() {
		return hdCertifiedNumber;
	}

	public void setHdCertifiedNumber(String hdCertifiedNumber) {
		this.hdCertifiedNumber = hdCertifiedNumber;
	}
	
	@Length(min=0, max=100, message="犬种简称长度必须介于 0 和 100 之间")
	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}
	
	@Length(min=0, max=10, message="是否热门标识长度必须介于 0 和 10 之间")
	public String getHot() {
		return hot;
	}

	public void setHot(String hot) {
		this.hot = hot;
	}

	public String getDogColor() {
		return dogColor;
	}

	public void setDogColor(String dogColor) {
		this.dogColor = dogColor;
	}

	public String getBatchMaxNum() {
		return batchMaxNum;
	}

	public void setBatchMaxNum(String batchMaxNum) {
		this.batchMaxNum = batchMaxNum;
	}

	public String getFciFlag() {
		return fciFlag;
	}

	public void setFciFlag(String fciFlag) {
		this.fciFlag = fciFlag;
	}

	public String getMemberCodeFlag() {
		return memberCodeFlag;
	}

	public void setMemberCodeFlag(String memberCodeFlag) {
		this.memberCodeFlag = memberCodeFlag;
	}
	
	
}