/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import org.hibernate.validator.constraints.Length;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 证书换发Entity
 * @author lgl
 * @version 2016-08-11
 */
public class DogPedigreeCertifiedChange extends DataEntity<DogPedigreeCertifiedChange> {

	private static final long serialVersionUID = 1L;
	private String dogId;		// 犬只信息表主键
	private String overseasPedigreeCertified;		// 国外血统证书号
	private String fmdogBreedCertifiedCode;		// 国外配种证明号
	private String dogBreed;		// 犬种
	private String dogName;		// 犬名
	private String dogGender;		// 犬只性别
	private String dogFurColor;		// 毛色
	private Date dogBirthday;		// 出生日期
	private String dogChip;		// 犬只芯片号
	private String dogChipCheck;		// 确认芯片：0否，1是
	private String dogDnaArchiveId;		// 犬只位点分析业务表id,dog_dna_archive表主键
	private String dogDnaArchiveIdFlag;		// OA列表页查询条件
	private String association;		// 协会
	private String orgId;		// 合作机构id,sys_org表主键
	private String orgName;		// 合作机构名称
	private String paymentMemberCode;		// 付款会员号
	private String operator;		// 操作人
	private String price;		// 价格
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核的意见
	private String runningNumber;		// 流水号
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// 付款时间
	private Date processTime;		// 流程变更的时间
	private String processState;		// 流程状态
	private Date beginCreateDate;		// 开始 create_date
	private Date endCreateDate;		// 结束 create_date
	private Date beginProcessDate;		// 处理开始 process_date
	private Date endProcessDate;		// 处理结束 process_date
	private String breedCnName;		// 犬种中文名
	private String dogOwnerName;		// 犬主姓名
	private String printState;		// 打印状态
	private Date sendDate;		// 邮寄日期
	private String stickerFlag;//申请贴纸标识:0不申请;1申请
	private String isCanceled;		// 是否撤销：0未撤销，1已撤销
	private String isFinish;		// 是否完成证书换发业务（是否打印证书）：0未完成，1已完成

	private String paymentChargingItemId;		//收费项id
	private String amphimixisId;     //配犬证明id
	private String pedigreeCertifiedCode;//犬只表血统证书号
	private String province;//省份

	private String businessState;		// 业务状态
	private String isCanCancel;		// 是否可以撤销标记位。0不可撤销；1可以撤销

	private String overseasPedigreeCertifiedLike;		//国外血统证书模糊查询条件

	private String callName;     //呼名
	public String getAmphimixisId() {
		return amphimixisId;
	}

	public void setAmphimixisId(String amphimixisId) {
		this.amphimixisId = amphimixisId;
	}

	public DogPedigreeCertifiedChange() {
		super();
	}

	public DogPedigreeCertifiedChange(String id){
		super(id);
	}

	public DogPedigreeCertifiedChange(String runningNumber,String paymentChargingItemId,String paymentMemberCode){
		this.runningNumber = runningNumber;
		this.paymentChargingItemId = paymentChargingItemId;
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min=0, max=64, message="犬只信息表主键长度必须介于 0 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	@Length(min=0, max=64, message="国外血统证书号长度必须介于 0 和 64 之间")
	public String getOverseasPedigreeCertified() {
		return overseasPedigreeCertified;
	}

	public void setOverseasPedigreeCertified(String overseasPedigreeCertified) {
		this.overseasPedigreeCertified = overseasPedigreeCertified;
	}

	public String getFmdogBreedCertifiedCode() {
		return fmdogBreedCertifiedCode;
	}

	public void setFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode) {
		this.fmdogBreedCertifiedCode = fmdogBreedCertifiedCode;
	}

	@Length(min=0, max=64, message="犬种长度必须介于 0 和 64 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	@Length(min=0, max=128, message="犬名长度必须介于 0 和 128 之间")
	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	@Length(min=0, max=10, message="犬只性别长度必须介于 0 和 10 之间")
	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	@Length(min=0, max=64, message="毛色长度必须介于 0 和 64 之间")
	public String getDogFurColor() {
		return dogFurColor;
	}

	public void setDogFurColor(String dogFurColor) {
		this.dogFurColor = dogFurColor;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getDogBirthday() {
		return dogBirthday;
	}

	public void setDogBirthday(Date dogBirthday) {
		this.dogBirthday = dogBirthday;
	}

	@Length(min=0, max=64, message="犬只芯片号长度必须介于 0 和 64 之间")
	public String getDogChip() {
		return dogChip;
	}

	public void setDogChip(String dogChip) {
		this.dogChip = dogChip;
	}

	public String getDogChipCheck() {
		return dogChipCheck;
	}

	public void setDogChipCheck(String dogChipCheck) {
		this.dogChipCheck = dogChipCheck;
	}

	public String getDogDnaArchiveId() {
		return dogDnaArchiveId;
	}

	public void setDogDnaArchiveId(String dogDnaArchiveId) {
		this.dogDnaArchiveId = dogDnaArchiveId;
	}

	public String getDogDnaArchiveIdFlag() {
		return dogDnaArchiveIdFlag;
	}

	public void setDogDnaArchiveIdFlag(String dogDnaArchiveIdFlag) {
		this.dogDnaArchiveIdFlag = dogDnaArchiveIdFlag;
	}

	public String getAssociation() {
		return association;
	}

	public void setAssociation(String association) {
		this.association = association;
	}

	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	@Length(min=0, max=64, message="付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min=0, max=64, message="操作人长度必须介于 0 和 64 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min=0, max=255, message="审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min=0, max=20, message="付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}

	@Length(min=0, max=20, message="流程状态长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getBreedCnName() {
		return breedCnName;
	}

	public void setBreedCnName(String breedCnName) {
		this.breedCnName = breedCnName;
	}

	public String getDogOwnerName() {
		return dogOwnerName;
	}

	public void setDogOwnerName(String dogOwnerName) {
		this.dogOwnerName = dogOwnerName;
	}

	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	public Date getSendDate() {
		return sendDate;
	}

	public void setSendDate(Date sendDate) {
		this.sendDate = sendDate;
	}

	public String getStickerFlag() {
		return stickerFlag;
	}

	public void setStickerFlag(String stickerFlag) {
		this.stickerFlag = stickerFlag;
	}

	public String getIsCanceled() {
		return isCanceled;
	}

	public void setIsCanceled(String isCanceled) {
		this.isCanceled = isCanceled;
	}

	public String getIsFinish() {
		return isFinish;
	}

	public void setIsFinish(String isFinish) {
		this.isFinish = isFinish;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public String getPedigreeCertifiedCode() {
		return pedigreeCertifiedCode;
	}

	public void setPedigreeCertifiedCode(String pedigreeCertifiedCode) {
		this.pedigreeCertifiedCode = pedigreeCertifiedCode;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getBusinessState() {
		return businessState;
	}

	public void setBusinessState(String businessState) {
		this.businessState = businessState;
	}

	public String getIsCanCancel() {
		return isCanCancel;
	}

	public void setIsCanCancel(String isCanCancel) {
		this.isCanCancel = isCanCancel;
	}

	public String getOverseasPedigreeCertifiedLike() {
		return overseasPedigreeCertifiedLike;
	}

	public void setOverseasPedigreeCertifiedLike(String overseasPedigreeCertifiedLike) {
		this.overseasPedigreeCertifiedLike = overseasPedigreeCertifiedLike;
	}

	public Date getBeginProcessDate() {
		return beginProcessDate;
	}

	public void setBeginProcessDate(Date beginProcessDate) {
		this.beginProcessDate = beginProcessDate;
	}

	public Date getEndProcessDate() {
		return endProcessDate;
	}

	public void setEndProcessDate(Date endProcessDate) {
		this.endProcessDate = endProcessDate;
	}

	public String getCallName() {
		return callName;
	}

	public void setCallName(String callName) {
		this.callName = callName;
	}
}