/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;
import java.util.List;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬主变更申请Entity
 * @author zhuoHeng
 * @version 2016-08-17
 */
public class DogOwnerChange extends DataEntity<DogOwnerChange> {

	private static final long serialVersionUID = 1L;
	private String dogId;		// 犬只信息表主键
	private String originOwnerMemberCode;		// 原犬主会员号
	private String originOwnerName;		// 原犬主姓名
	private String originSecondOwnerMemberCode;		// 原第二犬主会员号
	private String originSecondOwnerName;		// 原第二犬主姓名
	private String newOwnerMemberCode;		// 新犬主会员号
	private String newOwnerName;		// 新犬主姓名
	private String newSecondOwnerMemberCode;		// 新第二犬主会员号
	private String newSecondOwnerName;		// 新第二犬主姓名
	private String paymentMemberCode;		// 付款会员号
	private String operator;		// 操作人
	private String price;		// 价格
	private String reviewer;		// 审核人
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核的意见
	private String runningNumber;		// 流水号
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// 付款时间
	private Date processTime;		// 流程变更的时间
	private String processState;		// 流程状态
	private Dog dog;       //犬只信息实体
	private String dogBreed;

	private Date beginDate; //开始时间
	private Date endDate;		//结束时间
	private Date reviewBeginDate;
	private Date reviewEndDate;
	private String token; //宠爱王国访问令牌
	private String captcha; //安全手机验证码

	//收费项
	private String items;
	//新犬主是未缴费
	private String newOwnerMemberId;
	
	
	private List<String> reviewStateList;		// 审核状态
	
	public List<String> getReviewStateList() {
		return reviewStateList;
	}

	public void setReviewStateList(List<String> reviewStateList) {
		this.reviewStateList = reviewStateList;
	}

	public Date getBeginDate() {
		return beginDate;
	}

	public void setBeginDate(Date beginDate) {
		this.beginDate = beginDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public DogOwnerChange() {
		super();
	}

	public DogOwnerChange(String id){
		super(id);
	}

	@Length(min=0, max=64, message="犬只信息表主键长度必须介于 0 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	@Length(min=0, max=64, message="原犬主会员号长度必须介于 0 和 64 之间")
	public String getOriginOwnerMemberCode() {
		return originOwnerMemberCode;
	}

	public void setOriginOwnerMemberCode(String originOwnerMemberCode) {
		this.originOwnerMemberCode = originOwnerMemberCode;
	}

	@Length(min=0, max=64, message="原犬主姓名长度必须介于 0 和 64 之间")
	public String getOriginOwnerName() {
		return originOwnerName;
	}

	public void setOriginOwnerName(String originOwnerName) {
		this.originOwnerName = originOwnerName;
	}

	@Length(min=0, max=64, message="原第二犬主会员号长度必须介于 0 和 64 之间")
	public String getOriginSecondOwnerMemberCode() {
		return originSecondOwnerMemberCode;
	}

	public void setOriginSecondOwnerMemberCode(String originSecondOwnerMemberCode) {
		this.originSecondOwnerMemberCode = originSecondOwnerMemberCode;
	}

	@Length(min=0, max=64, message="原第二犬主姓名长度必须介于 0 和 64 之间")
	public String getOriginSecondOwnerName() {
		return originSecondOwnerName;
	}

	public void setOriginSecondOwnerName(String originSecondOwnerName) {
		this.originSecondOwnerName = originSecondOwnerName;
	}

	@Length(min=0, max=64, message="新犬主会员号长度必须介于 0 和 64 之间")
	public String getNewOwnerMemberCode() {
		return newOwnerMemberCode;
	}

	public void setNewOwnerMemberCode(String newOwnerMemberCode) {
		this.newOwnerMemberCode = newOwnerMemberCode;
	}

	@Length(min=0, max=64, message="新犬主姓名长度必须介于 0 和 64 之间")
	public String getNewOwnerName() {
		return newOwnerName;
	}

	public void setNewOwnerName(String newOwnerName) {
		this.newOwnerName = newOwnerName;
	}

	@Length(min=0, max=64, message="新第二犬主会员号长度必须介于 0 和 64 之间")
	public String getNewSecondOwnerMemberCode() {
		return newSecondOwnerMemberCode;
	}

	public void setNewSecondOwnerMemberCode(String newSecondOwnerMemberCode) {
		this.newSecondOwnerMemberCode = newSecondOwnerMemberCode;
	}

	@Length(min=0, max=64, message="新第二犬主姓名长度必须介于 0 和 64 之间")
	public String getNewSecondOwnerName() {
		return newSecondOwnerName;
	}

	public void setNewSecondOwnerName(String newSecondOwnerName) {
		this.newSecondOwnerName = newSecondOwnerName;
	}

	@Length(min=0, max=64, message="付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min=0, max=64, message="操作人长度必须介于 0 和 64 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min=0, max=64, message="审核人长度必须介于 0 和 64 之间")
	public String getReviewer() {
		return reviewer;
	}

	public void setReviewer(String reviewer) {
		this.reviewer = reviewer;
	}

	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min=0, max=255, message="审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min=0, max=20, message="付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}

	@Length(min=0, max=20, message="流程状态长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

    public Dog getDog() {
        return dog;
    }

    public void setDog(Dog dog) {
        this.dog = dog;
    }

	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	public Date getReviewBeginDate() {
		return reviewBeginDate;
	}

	public Date getReviewEndDate() {
		return reviewEndDate;
	}

	public void setReviewBeginDate(Date reviewBeginDate) {
		this.reviewBeginDate = reviewBeginDate;
	}

	public void setReviewEndDate(Date reviewEndDate) {
		this.reviewEndDate = reviewEndDate;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getCaptcha() {
		return captcha;
	}

	public void setCaptcha(String captcha) {
		this.captcha = captcha;
	}

	public String getItems() {
		return items;
	}

	public void setItems(String items) {
		this.items = items;
	}

	public String getNewOwnerMemberId() {
		return newOwnerMemberId;
	}

	public void setNewOwnerMemberId(String newOwnerMemberId) {
		this.newOwnerMemberId = newOwnerMemberId;
	}
}