/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import java.util.List;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.dog.entity.DogChip;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 新生犬登记DAO接口
 * 
 * @author zhuoHeng
 * @version 2016-08-04
 */
@MyBatisDao
public interface DogChipDao extends CrudDao<DogChip> {

	int deleteDogChipDogBirthCertificate(@Param("sql") String sql);

	int listCount(DogChip dogChip);

	public void changeStatus(DogChip dogChip);

	public void changeProcessState(DogChip dogChip);

	DogChip getByBirthCode(String birthCode);

	DogChip getByFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode);

	List<DogChip> getByFmdogBreedCertifiedCodes(String fmdogBreedCertifiedCode);

	DogChip getByBirthCodeAndNullRunningNumber(String birthCode);

	/**
	 *
	 * @Description：新生犬的登记撤销操作
	 * @author: zhuoHeng
	 * @version: 2016年10月25日 上午12:02:03
	 */
	void canceled(DogChip po);

	// 俱乐部 物理删除犬只芯片
	void deleteYes(DogChip byBirthCode);

	// 根据繁殖人会员号查询当年申请出生纸记录数
	int countByBreederMemberCodeCurrentYear(@Param("memberCode") String memberCode);

	// 根据俱乐部id查询办理的新生犬业务数量
	int countByClub(@Param("orgId") String orgId);

	List<DogChip> findByFmdogBreedCertifiedCode(@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode);

	void refundDogChip(@Param("vo") DogChip vo, @Param("ids") Set<String> ids);

	void updateEcertFlag(@Param("id") String id);

	int saveOrg(DogChip dogChip);
	
	int updateBusinessPrice(DogChip dogChip);
	
}