package com.cku.cab.editor.ckuhotel.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.cab.editor.ckuhotel.entity.CkuHotel;
import com.cku.cab.editor.ckuhotel.service.CkuHotelService;

/**
 * 美容培训酒店Controller
 * @author zhuoHeng
 * @version 2016-11-29
 */
@Controller
@RequestMapping(value = "${adminPath}/ckuhotel/ckuHotel")
public class CkuHotelController extends BaseController {

	@Autowired
	private CkuHotelService ckuHotelService;
	
	@ModelAttribute
	public CkuHotel get(@RequestParam(required=false) String id) {
		CkuHotel entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = ckuHotelService.get(id);
		}
		if (entity == null){
			entity = new CkuHotel();
		}
		return entity;
	}
	
	@RequiresPermissions("ckuhotel:ckuHotel:view")
	@RequestMapping(value = {"list", ""})
	public String list(CkuHotel ckuHotel, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<CkuHotel> page = ckuHotelService.findPage(new Page<CkuHotel>(request, response), ckuHotel); 
		model.addAttribute("page", page);
		return "editor/ckuhotel/ckuHotelList";
	}

	@RequiresPermissions("ckuhotel:ckuHotel:view")
	@RequestMapping(value = "form")
	public String form(CkuHotel ckuHotel, Model model) {
		model.addAttribute("ckuHotel", ckuHotel);
		return "editor/ckuhotel/ckuHotelForm";
	}

	@RequiresPermissions("ckuhotel:ckuHotel:edit")
	@RequestMapping(value = "save")
	public String save(CkuHotel ckuHotel, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, ckuHotel)){
			return form(ckuHotel, model);
		}
		ckuHotelService.save(ckuHotel);
		addMessage(redirectAttributes, "保存美容培训酒店成功");
		return "redirect:"+Global.getAdminPath()+"/ckuhotel/ckuHotel/?repage";
	}
	
	@RequiresPermissions("ckuhotel:ckuHotel:edit")
	@RequestMapping(value = "delete")
	public String delete(CkuHotel ckuHotel, RedirectAttributes redirectAttributes) {
		ckuHotelService.delete(ckuHotel);
		addMessage(redirectAttributes, "删除美容培训酒店成功");
		return "redirect:"+Global.getAdminPath()+"/ckuhotel/ckuHotel/?repage";
	}

}