define(["knockout", "sammy"], function(ko, Sammy) {
  //这里可以添加一些行为
  return function() {
    var self = this;
    //下面是基于js做的导航控制导航功能
    self.loading = ko.observable(false);
    self.moduleOptions = ko.observable({});
    self.loadError = ko.observableArray(false);
    self.updateError = ko.observable(false);

    self.updateError.subscribe(function(error) {
      if (error) {
        alert(error);
        self.updateError(false);
      }
    });

    self.loadError.subscribe(function(error) {
      if (error) {
        self.moduleOptions({
          name: "error",
          data: {
            app: self
          }
        });
      }
    });
    // 会员续费促销活动弹窗
    self.activePeriod = function() {
      util.sendAjax({
        url: "member/renewal/activePeriod",
        async: true,
        loadFlag: false,
        type: "GET",
        cache: false,
        success: function(json) {
          if (json.rc == 0) {
            if (json.data) {
              util.timeLocalStorage.Cache.put("activePeriodFlag", true, 3600);
              layer.open({
                type: 1,
                title: false,
                shadeClose: true,
                area: "1000px",
                content:
                  '<div><img onclick="window.open(\'http://www.cku.org.cn/inform/view/5030.html\')" style="width:1000px;height:500px;display:block;cursor: pointer;" src="images/home/active.jpg" alt="活动"></div>'
              });
            }
          }
        }
      });
    };
    //初始化subnav 事件
    $(function() {
      var activePeriodFlag = util.timeLocalStorage.Cache.get(
        "activePeriodFlag"
      );
      if (!activePeriodFlag) {
        self.activePeriod();
      }
    });

    Sammy(function() {
      this.get("#login", function() {
        self.moduleOptions({
          name: "login/login",
          data: {
            app: self
          }
        });
        self.loading(true);
      });

      this.get(/\#\/([^/]+)\/([^/]+)/, function() {
        var module = this.params.splat[0];
        var action = this.params.splat[1];

        self.moduleOptions({
          name: module + "/" + action,
          data: {
            app: self,
            data: {}
          }
        });
        self.loading(true);
      });

      this.get("/login.html", function() {
        this.app.runRoute("get", "#login");
      });
    });

    Sammy().run();
  };
});
