//丢失补做列表，变更补做列表，登录补做列表
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        // 证书补做类型：变更补做为1，丢失补做2，登录补做3，index进来默认为2,
        me.changeType = ko.observable("2");
        //申请的类型
        me.changeTypeText = ko.observable("证书丢失补做申请");
        //血统证书号码
        me.originalPedigreeCertified = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.finddogpedigreecertifiedredoloseList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.finddogpedigreecertifiedredoloseList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.finddogpedigreecertifiedredoloseList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.finddogpedigreecertifiedredoloseList(false);
            }
            return false;
        }
        /**
         * 丢失补做列表，变更补做列表，登录补做列表查询方法
         */
        me.finddogpedigreecertifiedredoloseList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["originalPedigreeCertified"] = me.originalPedigreeCertified().trim();
            sendData["changeType"] = me.changeType();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'dog/dogpedigreecertifiedredo',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0) {
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                            var type = "";
                            if(me.changeType()=="1"){
                                type = "变更";
                            }else if(me.changeType()=="2"){
                                type = "丢失";
                            }else if(me.changeType()=="3"){
                                type = "登录";
                            }
                            layer.msg(type+"补做列表为空！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        //未通过原因的显隐
        me.showReason = function(data,event){
            if(data.reviewState=='未通过'){
                if ($("#remarks"+data.id).css("display") == "none") {
                    $("#remarks"+data.id).css("display", "block");
                } else {
                    $("#remarks"+data.id).css("display", "none")
                }
            }
        }
        me.closeReason = function(data,event){
            $("#remarks"+data.id).css("display","none")
        }
/*        //撤销补做
        me.delChange = function(data,event){
            if(data.processState=='撤销'){
                //询问框
                var delChangelayer = layer.confirm('撤销后将无法进行证书补做！', {
                    btn: ['确定','关闭'] //按钮
                }, function(){
                    var id = data.id;
                    util.sendAjax({
                        url:'dog/dogpedigreecertifiedredo/'+id,
                        data:{},
                        async:true,
                        loadFlag:true,
                        type:'DELETE',
                        cache:false,
                        success:function(data){
                            if(data.rc==0){
                                layer.close(delChangelayer);
                                layer.msg("证书补做撤销成功！");
                                me.finddogpedigreecertifiedredoloseList(false);
                            }else{
                                layer.msg("撤销补做失败:"+data.msg);
                            }
                        }
                    });
                });
            }
        }*/
        $(function(){
            var obj = util.getQueryString();
            if(!util.isVal(obj.changeType)==""){
                me.changeType(obj.changeType);
                if(obj.changeType=="1"){
                    me.changeTypeText("证书变更补做申请");
                }else if(obj.changeType=="2"){
                    me.changeTypeText("证书丢失补做申请");
                }else if(obj.changeType=="3"){
                    me.changeTypeText("证书登录补做申请");
                }
            }
            me.finddogpedigreecertifiedredoloseList(false);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});