<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只DNA存档管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/dogDnaArchive">DNA存档管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogDnaArchive" action="${ctxDc}/dogDnaArchive" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">	
			<li><label>血统证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>国外血统证书号：</label>
				<form:input path="overseasPedigreeCertifiedLike" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>DNA编号：</label>
				<form:input path="dnaCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>出生纸编号：</label>
				<form:input path="birthCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>订单状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>处理状态：</label>
				<form:select path="processState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogDnaArchive.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogDnaArchive.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>血统证书编号</th>
				<th>国外血统证书号</th>
				<th>犬主</th>
				<th>出生纸编号</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>撤销状态</th>
				<th>DNA信息</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogDnaArchive">
			<tr>
				<td>
					${fns:escapeHtml(dogDnaArchive.pedigreeCertifiedCode)}
				</td>
				<td>
					${fns:escapeHtml(dogDnaArchive.overseasPedigreeCertified)}
				</td>
				<td title="${fns:escapeHtml(dogDnaArchive.paymentMemberCode)}">
					${fns:escapeHtml(dogDnaArchive.memberName)}
				</td>
				<td>
					${fns:escapeHtml(dogDnaArchive.birthCode)}
				</td>
				<td>
					<fmt:formatDate value="${dogDnaArchive.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td style="color:${dogDnaArchive.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogDnaArchive.paymentState, 'user_payment_state', '')}
				</td>
				<td title="${fns:escapeHtml(dogDnaArchive.reviewRemarks)}" style="color:#000">
					<c:if test="${dogDnaArchive.paymentState=='2'}">
					<c:choose>
						<c:when test="${dogDnaArchive.reviewState=='0'||dogDnaArchive.reviewState=='2'}">
							<a style="color:#F00" onclick="auditForm('${fns:escapeHtml(dogDnaArchive.id)}')">
							${fns:getDictLabel(dogDnaArchive.reviewState, 'review_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogDnaArchive.reviewState, 'review_state', '')}
						</c:otherwise>
					</c:choose>
					</c:if>
				</td>
				<td>
					<c:if test="${dogDnaArchive.isCanceled=='1'}">
						已撤销
					</c:if>
				</td>
				<td>
					<c:choose>
						<c:when test="${not empty dogDnaArchive.dnaCode}">
							<a onclick="resolveForm('${dogDnaArchive.id}')">${fns:escapeHtml(dogDnaArchive.dnaCode)}</a>
						</c:when>
						<c:when test="${empty dogDnaArchive.dnaCode&&dogDnaArchive.reviewState=='1'}">
							<a style="color:#F00" onclick="resolveForm('${dogDnaArchive.id}')">录入</a>
						</c:when>
					</c:choose>
				</td>
				<td>
					<a href="${ctxDc}/dogDnaArchive/form?id=${dogDnaArchive.id}">查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>