<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容师结业证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">当前位置:结业证书编辑</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="groomerDiploma" action="${ctxSchools}/schoolsCourse/diplomaEditSave" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="100" readonly="true" class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="64" readonly="true" class="input-xlarge " />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训课程：</label>
			<div class="controls">
				<form:select  path="groomerCourseId" class="input-xlarge required" onchange="selectCourse()" >
					<form:option value="" label=""/>
	             	<form:options items="${findList}" itemLabel="courseName" itemValue="id" htmlEscape="false"/>
	   		  </form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书级别：</label>
			<div class="controls">
				<form:select path="certificateLevel" class="input-xlarge required" disabled="true">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('groomer_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开始时间：</label>
			<div class="controls">
				<input id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${groomerDiploma.startDate}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束时间：</label>
			<div class="controls">
				<input id="endDate"  name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${groomerDiploma.endDate}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训教师：</label>
			<div class="controls">
				<form:input path="teacher" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">中文学校名：</label>
			<div class="controls">
				<form:input path="schoolNameCn" htmlEscape="false" readonly="true" maxlength="150" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">学校英文名：</label>
			<div class="controls">
				<form:input path="schoolNameEn" htmlEscape="false" readonly="true" maxlength="150" class="input-xlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script type="text/javascript">
	Date.prototype.format = function(fmt) { 
	     var o = { 
	        "M+" : this.getMonth()+1,                 //月份 
	        "d+" : this.getDate(),                    //日 
	        "h+" : this.getHours(),                   //小时 
	        "m+" : this.getMinutes(),                 //分 
	        "s+" : this.getSeconds(),                 //秒 
	        "q+" : Math.floor((this.getMonth()+3)/3), //季度 
	        "S"  : this.getMilliseconds()             //毫秒 
	    }; 
	    if(/(y+)/.test(fmt)) {
	            fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length)); 
	    }
	     for(var k in o) {
	        if(new RegExp("("+ k +")").test(fmt)){
	             fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
	         }
	     }
	    return fmt; 
	}
	//回显所选课程的信息
	function selectCourse(){
		var  groomerCourseId = $("#groomerCourseId").val();
		if(groomerCourseId!=''){
			$.ajax({
				   type:"POST",
	                url: "${ctxSchools}/schoolsCourse/rockMsg",
	                data : {'id':groomerCourseId},
	                dataType: 'json',
	                async: false, 
	                success: function(json){
	                	if(json.rc==true){
	                		$("#startDate").val(new Date(json.startDate).format("yyyy-MM-dd"));
	                		$("#endDate").val(new Date(json.endDate).format("yyyy-MM-dd"));
	                		$("#certificateLevel").val(json.diplomaLevel);
	                		$("#teacher").val(json.teacher);
	                		$("#certificateLevel").trigger("change"); 
	                	}else if(json.rc==false){
	                		$.jBox.alert(json.msg,"提示");
	                	}
	                }
			});
		}
	}
	</script>
</body>
</html>