<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合作机构、合作医院管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function dogNose(id){
			parent.layer.open({
				type: 2,
				title: ['鼻纹设置', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '350px'],
				content: "${ctx}/sys/org/dogNose/form?id="+id,
			});

			return false;
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/org/">合作机构列表</a></li>
		<shiro:hasPermission name="sys:org:edit"><li><a href="${ctx}/sys/org/form">合作机构添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="org" action="${ctx}/sys/org/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>机构名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>芯片号：</label>
				<form:input path="chip" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>机构类型：</label>
				<form:select path="orgType" class="input-small">
					<form:options items="${fns:getDictList('sys_org_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>状态：</label>
				<form:select path="state" class="input-small">
					<form:option value="all">全部</form:option>
					<form:option value="0">开放</form:option>
					<form:option value="1">关闭</form:option>
				</form:select>
			</li>
            <li><label>审核状态：</label>
                <form:select path="shenHeState" class="input-small">
					<form:option value="">全部</form:option>
                    <form:option value="0">待审核</form:option>
                    <form:option value="1">通过</form:option>
                    <form:option value="2">未通过</form:option>
                </form:select>
            </li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>机构名称</th>
				<th>机构类型</th>
				<th>合作编号</th>
				<th>状态</th>
				<th>截止日期</th>
				<th>审核</th>
				<th>押金</th>
				<th>余额</th>
				<th>官网是否显示</th>
				<th>邮寄管理</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="org">
			<tr>
				<td><a href="${ctx}/sys/org/form?id=${org.id}">
					${org.name}
				</a></td>
				<td>
					${fns:getDictLabels(org.orgType, 'sys_org_type', '')}
				</td>
				<td>
					<%--<c:if test="${org.orgType eq 'club'}">--%>
						<a href="${ctx}/sys/user/member/view?id=${org.member.id}">
						${org.memberCode }
						</a>
					<%--	</c:if>--%>
				</td>

				<td>
					<c:if test="${org.endDate gt currentDate}" > <font color="green">开放</font></c:if>
					<c:if test="${org.endDate lt currentDate}" > <font color="red">关闭</font> </c:if>
					<c:if test="${org.endDate eq currentDate}" > 今天关闭 </c:if>
				</td>
				<td>
					<fmt:formatDate value="${org.endDate}" type="date" pattern="yyyy-MM-dd "/>

				</td>
				<td>
					<c:if test="${org.shenHeState==0}" > 未审核 </c:if>
					<c:if test="${org.shenHeState==1}" > 通过 </c:if>
					<c:if test="${org.shenHeState==2}" > 未通过 </c:if>
				</td>
				<td>
					${org.deposit}
				</td>
				<td>
					<c:if test="${org.orgType eq 'club'}">
					${org.member.accountBalance }
					</c:if>
				</td>
				<td>
						${fns:getDictLabel(org.displayOnWeb, 'yes_no', '')}
				</td>
				<td>
					<a href="${ctx }/sys/orgChip/add?orgId=${org.id}">物资录入</a>
					<a href="${ctx }/sys/orgChip/group?orgId=${org.id}">物资管理</a>
					<shiro:hasPermission name="org:orgSampling:add">
					<a href="${ctx }/org/orgSampling/addForm?orgId=${org.id}">采样包录入</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="org:orgSampling:view">
					<a href="${ctx }/org/orgSampling/groupList?orgId=${org.id}">采样包管理</a>
					</shiro:hasPermission>
				</td>

				<td>
					<shiro:hasPermission name="sys:org:edit">
    					<a href="${ctx}/sys/org/form?id=${org.id}">修改</a>
    				</shiro:hasPermission>
					<shiro:hasPermission name="sys:org:dogNoseEdit">
						<a href="javascript:;"  onclick="dogNose('${org.id}')">鼻纹设置</a>
    				</shiro:hasPermission>
    				<shiro:hasPermission name="sys:org:delete">
						<a href="${ctx}/sys/org/delete?id=${org.id}" onclick="return confirmx('确认要删除该合作机构吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>