<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>业务扣费</title>
<meta name="decorator" content="default" />
<script type="text/javascript">
	$(document)
			.ready(
					function() {
						var oldProvince = '${regionRevenue.province}';
						/* var html = "<option  value='' code=''>全部</option>"; */
						var html = "";
						<c:forEach items="${regions}" var="region" >
						var province = '${region.label}';
						if (oldProvince == province) {
							html += "<option selected = 'selected' value='"+'${region.label}'+"' >"
									+ "${region.label}" + "</option>";
						} else {
							html += "<option  value='"+'${region.label}'+"' >"
									+ "${region.label}" + "</option>";
						}
						</c:forEach>
						$("#province").append(html);
						$("#province").trigger("change");
					});

	function exportStatistics() {
		var endDate = document.getElementById("endDate").value;
		var startDate = document.getElementById("startDate").value;
		if (endDate == "" || startDate == "") {
			alert("起止时间不能为空");
			return false;
		} else {
			 $.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctx}/statistics/region/report/export?startDate="+startDate+"&endDate="+endDate,
	                async: true,
	                success: function(data) {
		                alert("请稍后在 大区业务统计-统计报表下载，文件名称" + data.fileName);
	                }
				});
		}
		return false;
	}

	function mySubmit() {
		var endDate = document.getElementById("endDate").value;
		var startDate = document.getElementById("startDate").value;
		if (endDate == "" || startDate == "") {
			alert("起止时间不能为空");
			return false;
		} else {
			document.getElementById("searchForm").submit();
		}
	}

	function memberAccountPage(startDate, endDate, chargingItemID, province) {
		parent.layer
				.open({
					type : 2,
					title : [ '业务扣费明细', 'font-size:18px;text-align: center;' ],
					shadeClose : false,
					shade : [ 0.8, '#393D49' ],
					maxmin : false, //开启最大化最小化按钮
					area : [ '1200px', '800px' ],
					content : "${ctx}/finance/memberAccount/regionList?paymentTimeStart="
							+ startDate
							+ "&paymentTimeEnd="
							+ endDate
							+ "&chargingItemId="
							+ chargingItemID
							+ "&source="
							+ "regionsStatistics" + "&province=" + province
				});
	}

	function orderListPage(startDate, endDate, chargingItemID, orderType,
			isShowCoupon, province) {
		parent.layer.open({
			type : 2,
			title : [ '业务扣费明细', 'font-size:18px;text-align: center;' ],
			shadeClose : false,
			shade : [ 0.8, '#393D49' ],
			maxmin : false, //开启最大化最小化按钮
			area : [ '1200px', '800px' ],
			content : "${ctx}/statistics/region/orderList?startDate="
					+ startDate + "&endDate=" + endDate + "&chargingItemID="
					+ chargingItemID + "&orderType=" + orderType
					+ "&isShowCoupon=" + isShowCoupon + "&province=" + province
		});
	}
</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">业务扣费</a></li>
	</ul>
	<form id="searchForm" modelAttribute="regionRevenue"
		action="${ctx}/statistics/region/revenue" method="post"
		class="breadcrumb form-search">
		<ul class="ul-form">
			<li><label>省份：</label> <select id="province" name="province"
				class="input-small">
					<option value="" code="">全部</option>
			</select></li>
			<li><label>开始时间：</label> <input id="startDate"
				style="width: 160px;" name="startDate" type="text"
				readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="${regionRevenue.startDate}"
				onclick="WdatePicker({startDate:'%y-%M-%d 00:00:00', dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" />
			</li>
			<li><label style="width: 100px;">结束时间：</label> <input
				id="endDate" style="width: 160px;" name="endDate" type="text"
				readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="${regionRevenue.endDate}"
				onclick="WdatePicker({startDate:'%y-%M-%d 23:59:59', dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" />
			</li>
			<li class="btns"><input id="btnSubmit" name="btnSubmit"
				class="btn btn-primary" type="submit" value="查询"
				onClick="return mySubmit()" /> <shiro:hasPermission
					name="statistics:region:export">
					<input id="btnSubmit" name="btnSubmit" class="btn btn-primary"
						type="submit" value="导出" onClick="return exportStatistics()" />
				</shiro:hasPermission></li>
			<li class="clearfix"></li>
		</ul>
	</form>
	<c:forEach items="${chargeDetails}" var="chargeDetails">
		<c:if
			test="${chargeDetails.officeName!='财务部' && chargeDetails.officeName!='合作单位'}">
			<hr
				style="height: 2px; border: none; border-top: 2px groove skyblue;" />
			<p style="text-align: left; font-size: 18px; line-height: 30px;">
				<b style="color: #9999ff;"><c:if
						test="${chargeDetails.officeName=='平阳办事处'}">CKU</c:if> <c:if
						test="${chargeDetails.officeName !='平阳办事处'}">${chargeDetails.officeName}</c:if></b><b>业务扣费统计</b>
			</p>
			<table id="${chargeDetails.officeName}"
				class="table table-striped table-bordered table-condensed">
				<thead>
					<tr>
						<th>收费项目(价格)</th>
						<th colspan="2">合作机构</th>
						<th colspan="2">会员中心</th>
						<th colspan="2">业务订单</th>
						<th colspan="2">OA扣费</th>
						<th>总数</th>
						<th>总金额（元）</th>
					</tr>
				</thead>
				<tbody>
					<c:forEach items="${chargeDetails.chargeItem}" var="chargeItem">
						<%--判断是否为赛事收费项--%>
						<c:set var="isShow" value="false" />
						<c:forEach items="${showChargeItemID}" var="showId">
							<c:if test="${showId eq chargeItem.chargeID}">
								<c:set var="isShow" value="true" />
							</c:if>
						</c:forEach>
						<%--判断是否为优惠券收费项--%>
						<c:set var="isShowCoupon" value="false" />
						<c:forEach items="${showChargeCouponItemID}" var="showId">
							<c:if test="${showId eq chargeItem.chargeID}">
								<c:set var="isShowCoupon" value="true" />
							</c:if>
						</c:forEach>
						<tr>
							<td>${fns:escapeHtml(chargeItem.chargeItem)}<a
								href="${ctx}/finance/statistics/export?paymentState=2&source=region&province=${regionRevenue.province}&chargeItem=${fns:escapeHtml(chargeItem.chargeItem)}&startDate=${regionRevenue.startDate}&endDate=${regionRevenue.endDate}&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}">导出</a>
							</td>

							<c:choose>
								<c:when test="${chargeItem.corpNum==0}">
									<td><fmt:formatNumber
											value="${fns:escapeHtml(chargeItem.corpNum)}"
											pattern="#,##0.00#" maxFractionDigits="0" /></td>
								</c:when>
								<c:otherwise>
									<td><a href="###"
										onclick="orderListPage( '${regionRevenue.startDate}' , '${regionRevenue.endDate}' , '${fns:escapeHtml(chargeItem.chargeID)}'  ,'corp'  , '' , '${regionRevenue.province }')"><fmt:formatNumber
												value="${fns:escapeHtml(chargeItem.corpNum)}"
												pattern="#,##0.00#" maxFractionDigits="0" /></a> <%-- <a
										href="${ctx}/finance/statistics/orderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=corp&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber
												value="${fns:escapeHtml(chargeItem.corpNum)}"
												pattern="#,##0.00#" maxFractionDigits="0" /></a> --%></td>
								</c:otherwise>
							</c:choose>
							<td><fmt:formatNumber
									value="${fns:escapeHtml(chargeItem.corpFee)}"
									pattern="#,##0.00#" maxFractionDigits="2" /></td>
							<c:choose>
								<c:when test="${chargeItem.memberNum==0}">
									<td><fmt:formatNumber
											value="${fns:escapeHtml(chargeItem.memberNum)}"
											pattern="#,##0.00#" maxFractionDigits="0" /></td>
								</c:when>
								<c:when test="${isShow}">
									<td><a
										href="${ctx}/statistics/activity/showOrderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=member&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber
												value="${fns:escapeHtml(chargeItem.memberNum)}"
												pattern="#,##0.00#" maxFractionDigits="0" /></a></td>
								</c:when>
								<c:when test="${isShowCoupon}">


									<td><a href="###"
										onclick="orderListPage( '${regionRevenue.startDate}' , '${regionRevenue.endDate}' , '${fns:escapeHtml(chargeItem.chargeID)}'  ,'member' , '1' , '${regionRevenue.province }')"><fmt:formatNumber
												value="${fns:escapeHtml(chargeItem.memberNum)}"
												pattern="#,##0.00#" maxFractionDigits="0" /></a> <%-- 	<a
										href="${ctx}/finance/statistics/orderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=member&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}&isShowCoupon=1"><fmt:formatNumber
												value="${fns:escapeHtml(chargeItem.memberNum)}"
												pattern="#,##0.00#" maxFractionDigits="0" /></a> --%></td>
								</c:when>
								<c:otherwise>
									<td><a href="###"
										onclick="orderListPage( '${regionRevenue.startDate}' , '${regionRevenue.endDate}' , '${fns:escapeHtml(chargeItem.chargeID)}'  ,'member' , '' ,'${regionRevenue.province }' )"><fmt:formatNumber
												value="${fns:escapeHtml(chargeItem.memberNum)}"
												pattern="#,##0.00#" maxFractionDigits="0" /></a> <%-- <a
										href="${ctx}/finance/statistics/orderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=member&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber
												value="${fns:escapeHtml(chargeItem.memberNum)}"
												pattern="#,##0.00#" maxFractionDigits="0" /></a> --%></td>
								</c:otherwise>
							</c:choose>
							<td><fmt:formatNumber
									value="${fns:escapeHtml(chargeItem.memberFee)}"
									pattern="#,##0.00#" maxFractionDigits="2" /></td>

							<c:choose>
								<c:when test="${chargeItem.orderNum==0}">
									<td><fmt:formatNumber
											value="${fns:escapeHtml(chargeItem.orderNum)}"
											pattern="#,##0.00#" maxFractionDigits="0" /></td>
								</c:when>
								<c:otherwise>
									<td><a href="###"
										onclick="orderListPage( '${regionRevenue.startDate}' , '${regionRevenue.endDate}' , '${fns:escapeHtml(chargeItem.chargeID)}'  ,'order' , '' ,'${regionRevenue.province }')"><fmt:formatNumber
												value="${fns:escapeHtml(chargeItem.orderNum)}"
												pattern="#,##0.00#" maxFractionDigits="0" /></a> <%-- <a
										href="${ctx}/finance/statistics/orderList?paymentState=2&startDate=${startDate}&endDate=${endDate}&orderType=order&chargingItemID=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber
												value="${fns:escapeHtml(chargeItem.orderNum)}"
												pattern="#,##0.00#" maxFractionDigits="0" /></a> --%></td>
								</c:otherwise>
							</c:choose>
							<td><fmt:formatNumber
									value="${fns:escapeHtml(chargeItem.orderFee)}"
									pattern="#,##0.00#" maxFractionDigits="2" /></td>

							<c:choose>
								<c:when test="${chargeItem.OANum==0}">
									<td><fmt:formatNumber
											value="${fns:escapeHtml(chargeItem.OANum)}"
											pattern="#,##0.00#" maxFractionDigits="0" /></td>
								</c:when>
								<c:otherwise>
									<td><a href="###"
										onclick="memberAccountPage( '${regionRevenue.startDate}' , '${regionRevenue.endDate}' , '${fns:escapeHtml(chargeItem.chargeID)}' , '${regionRevenue.province }')"><fmt:formatNumber
												value="${fns:escapeHtml(chargeItem.OANum)}"
												pattern="#,##0.00#" maxFractionDigits="0" /></a> <%--  <a
										href="${ctx}/finance/memberAccount?paymentTimeStart=${startDate}&paymentTimeEnd=${endDate}&chargingItemId=${fns:escapeHtml(chargeItem.chargeID)}"><fmt:formatNumber
												value="${fns:escapeHtml(chargeItem.OANum)}"
												pattern="#,##0.00#" maxFractionDigits="0" /></a>  --%></td>
								</c:otherwise>
							</c:choose>
							<td><fmt:formatNumber
									value="${fns:escapeHtml(chargeItem.OAFee)}" pattern="#,##0.00#"
									maxFractionDigits="2" /></td>
							<td><fmt:formatNumber
									value="${fns:escapeHtml(chargeItem.countNum)}"
									pattern="#,##0.00#" maxFractionDigits="0" /></td>
							<td><fmt:formatNumber
									value="${fns:escapeHtml(chargeItem.countFee)}"
									pattern="#,##0.00#" maxFractionDigits="2" /></td>
						</tr>
					</c:forEach>
				</tbody>
				<tbody>
					<tr>
						<td><b>合计</b></td>
						<td><fmt:formatNumber
								value="${chargeDetails.totalCount.countCoreNum}"
								pattern="#,##0.00#" maxFractionDigits="0" /></td>
						<td><fmt:formatNumber
								value="${chargeDetails.totalCount.countCoreFee}"
								pattern="#,##0.00#" maxFractionDigits="2" /></td>
						<td><fmt:formatNumber
								value="${chargeDetails.totalCount.countMemberNum}"
								pattern="#,##0.00#" maxFractionDigits="0" /></td>
						<td><fmt:formatNumber
								value="${chargeDetails.totalCount.countMemberFee}"
								pattern="#,##0.00#" maxFractionDigits="2" /></td>
						<td><fmt:formatNumber
								value="${chargeDetails.totalCount.countOrderNum}"
								pattern="#,##0.00#" maxFractionDigits="0" /></td>
						<td><fmt:formatNumber
								value="${chargeDetails.totalCount.countOrderFee}"
								pattern="#,##0.00#" maxFractionDigits="2" /></td>
						<td><fmt:formatNumber
								value="${chargeDetails.totalCount.countOANum}"
								pattern="#,##0.00#" maxFractionDigits="0" /></td>
						<td><fmt:formatNumber
								value="${chargeDetails.totalCount.countOAFee}"
								pattern="#,##0.00#" maxFractionDigits="2" /></td>
						<td><fmt:formatNumber
								value="${chargeDetails.totalCount.totalCountNum}"
								pattern="#,##0.00#" maxFractionDigits="0" /></td>
						<td><fmt:formatNumber
								value="${chargeDetails.totalCount.totalCountFee}"
								pattern="#,##0.00#" maxFractionDigits="2" /></td>
					</tr>
				</tbody>
				<tbody>
					<tr>
						<td style="text-align: right;" colspan="11" valign="top"
							style="padding: 0;"><strong
							style="font-size: 12px; display: inline-block;">${regionRevenue.startDate}至${regionRevenue.endDate}
								共计：</strong> <span style="font-size: 20px; color: #9999ff;"><fmt:formatNumber
									type="currency"
									value="${chargeDetails.totalCount.totalCountFee}"
									maxFractionDigits="2" /></span> <strong
							style="font-size: 20px; display: inline-block;">元</strong></td>
					</tr>
				</tbody>
			</table>
		</c:if>
	</c:forEach>

	<c:if test="${display == 'show'}">
		<hr style="height: 2px; border: none; border-top: 2px groove skyblue;" />
		<p style="text-align: right;">
			<strong style="font-size: 24px; display: inline-block;">${regionRevenue.startDate}至${regionRevenue.endDate}
				业务扣费合计：</strong> <span style="font-size: 32px; color: #9999ff;"><fmt:formatNumber
					type="currency" value="${chargeTotal}" maxFractionDigits="2" /></span> <strong
				style="font-size: 24px; display: inline-block;">元</strong>
		</p>
	</c:if>

</body>
</html>