<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>出生证明统计</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		
		function SubmitByDate(date)
		{
			document.getElementById("nowDate").value=date
			 document.getElementById("searchForm").submit();
		}
		</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/statistics/dog/regionalDistribution">犬只信息统计</a></li>
		<li><a href="${ctx}/statistics/dog/BreedCertified">配种证明统计</a></li>
		<li class="active"><a href="${ctx}/statistics/dog/BirthCertificate">出生证明统计</a></li>
	</ul>
	<form id="searchForm"  action="${ctx}/statistics/dog/BirthCertificate" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>选择地区：</label>			
				<select id="province" name="province" class="input-small">
					<option value="">全国</option>
							<c:forEach items="${provinces}" var="p">
								<option value="${fns:escapeHtml(p.name) }"  
									<c:if test="${p.name eq province }">
										selected = "selected"
									</c:if>>${fns:escapeHtml(p.name) }
								</option>
							</c:forEach>					
				</select>
			</li>
			<li><label>开始时间：</label>
				<input id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				value="${startDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			
			<li><label>结束时间：</label>
				<input id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
				value="${endDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit_gen" class="btn btn-primary" type="button" onclick="SubmitByDate('day')" value="查询"/></li>
			<li class="btns"><input id="btnSubmit_current_month" class="btn btn-primary" type="button" value="本月" onclick="SubmitByDate('month')"/></li>
			<li class="btns"><input id="btnSubmit_current_yearh" class="btn btn-primary" type="button" value="本年" onclick="SubmitByDate('year')"/></li>
			<li><input id="nowDate" type="hidden" name="nowDate" value=""/></li>
			<li class="clearfix"></li>
		</ul>
	</form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员姓名</th>
				<th>会员号</th>
				<th>出生证明申请数量</th>
				<th>出生证明转化证书数量</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${results}" var="result">
			<tr>
				<td>
					${fns:escapeHtml(result.dog_owenr)}
				</td>
				<td>
					${fns:escapeHtml(result.member_code)}
				</td>
				<td>
					${fns:escapeHtml(result.birth_cer_reg)}
				</td>
				<td>
					${fns:escapeHtml(result.birth_cer_change)}
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>