<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展秩序册管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/show/showReportScore/">犬展秩序册列表</a></li>
		<li class="active"><a href="${ctx}/show/showReportScore/editForm?id=${showReportScore.id}">犬展秩序册<shiro:hasPermission name="show:showReportScore:edit">${not empty showReportScore.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="show:showReportScore:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showReportScore" action="${ctx}/show/showReportScore/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">犬展编号：</label>
			<div class="controls">
				<form:input path="showCode" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">秩序号：</label>
			<div class="controls">
				<form:input path="orderNumber" htmlEscape="false" maxlength="10" class="input-xlarge "/>
			</div>
		</div>

		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				<form:input path="pedigreeCertifiedCode" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>

		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">FCI代码：</label>
			<div class="controls">
				<form:input path="fciCode" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:input path="dogSex" htmlEscape="false" maxlength="2" class="input-xlarge " />
			</div>
		</div>
		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">年龄组别：</label>
			<div class="controls">
				<form:select path="dogYearGroup" class="input-xlarge " >
					<form:options items="${fns:getDictList('show_age_group')}" itemLabel="label" itemValue="value"  htmlEscape="false"/>
				</form:select>
			</div>
		</div>

		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">裁判：</label>
			<div class="controls">
				<form:select path="judgeId" class="input-xlarge ">
					<form:options items="${judges}" itemLabel="judgeName" itemValue="id" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group" style="width: 50%;float: left">
			<label class="control-label">活动区域：</label>
			<div class="controls">
				<form:input path="showCircle" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>

		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬主中文名：</label>
			<div class="controls">
				<form:input path="dogOwnerZh" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬主会员号：</label>
			<div class="controls">
				<form:input path="dogOwnerCode" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>

		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬种中文：</label>
			<div class="controls">
				<form:input path="dogTypeZh" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬种英文：</label>
			<div class="controls">
				<form:input path="dogTypeEn" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬名：</label>
			<div class="controls">
				<form:input path="dogName" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>

		<div class="control-group"  style="width: 50%;float: left">
			<label class="control-label">犬主牵犬师：</label>
			<div class="controls">
				<form:input path="dogOwnerHandler" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>

		<div class="control-group"  style="width: 100%;float: left">
			<label class="control-label">修改说明：</label>
			<div class="controls">
				<form:input path="remarks" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>


		<div class="form-actions" style="width: 89%;float: right;">
			<shiro:hasPermission name="show:showReportScore:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>