<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>赛事顾问管理</title>
	<meta name="decorator" content="default"/>
	<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			if('${isView}' == 1){
				$('#btnSubmit').hide();
				$('#inputForm input').attr('disabled', 'true');
				$('#inputForm select').attr('disabled', 'true');
				$('#inputForm textarea').attr('disabled', 'true');
				$('#inputForm input').unbind();
				$('#btnCancel').removeAttr('disabled');
			}

			$("#btnSubmit").click(function () {
				let name = $("#name").val();
				if (name.length <= 0) {
					alert("顾问名称不能为空");
					return;
				}

				//提交
				$("#inputForm").ajaxSubmit({
					dataType: 'json',
					beforeSubmit: function () {
						if (!$("#inputForm").valid()) {
							return false;
						}
					},
					success: function (data) {
						if (data.rc == 0) {
							layer.msg("保存成功！");
							window.location = "${ctx}/show/showAdvisor/"
						} else {
							layer.msg(data.msg);
						}
					},
					error: function (err) {
						layer.msg("操作失败!");
					}
				});
			});
		});
	</script>
	<!--引入wangEditor.css-->
	<link rel="stylesheet" type="text/css" href="${ctxStatic }/wangEditor/css/wangEditor.min.css" />
	<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
	<script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
	<script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/show/showAdvisor/">赛事顾问列表</a></li>
		<li class="active">
			<c:choose>
				<c:when test="${isView==1}">
					<a href="${ctx}/show/showAdvisor/viewForm?id=${showAdvisor.id}">赛事顾问查看</a>
				</c:when>
				<c:otherwise>
					<a href="${ctx}/show/showAdvisor/editForm?id=${showAdvisor.id}">赛事顾问<shiro:hasPermission name="show:showAdvisor:edit">${not empty showAdvisor.id?'修改':'添加'}</shiro:hasPermission>
					</a>
				</c:otherwise>
			</c:choose>
		</li>
	</ul><br/>
	<form:form style="min-height:1898px" id="inputForm" modelAttribute="showAdvisor" action="${ctx}/show/showAdvisor/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名-英文：</label>
			<div class="controls">
				<form:input path="nameEn" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">图片：</label>
			<div class="controls">
				<sys:singleImgUpload module="showAdvisor" imgId="${showAdvisor.picture}" state="1" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*500*1" successCallback="uploadSuccess"/>
				<form:input path="picture" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#picture").val(response.id);
					}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">从业时间：</label>
			<div class="controls">
				<form:input path="involvedInto" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">从业时间-英文：</label>
			<div class="controls">
				<form:input path="involvedIntoEn" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">担任轮值顾问年：</label>
			<div class="controls">
				<form:input path="electedInto" htmlEscape="false" maxlength="150" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">担任轮值顾问年-英文：</label>
			<div class="controls">
				<form:input path="electedIntoEn" htmlEscape="false" maxlength="150" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">头衔：</label>
			<div class="controls">
				<form:input path="title" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">头衔-英文：</label>
			<div class="controls">
				<form:input path="titleEn" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">从业经历：</label>
			<div class="controls">
				<form:textarea  path="experience" style="height:400px" htmlEscape="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">从业经历-英文：</label>
			<div class="controls">
				<form:textarea  path="experienceEn" style="height:400px" htmlEscape="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍名称：</label>
			<div class="controls">
				<form:input path="kennelName" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍名称-英文：</label>
			<div class="controls">
				<form:input path="kennelNameEn" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">繁殖品种：</label>
			<div class="controls">
				<form:input path="breedType" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">繁殖品种-英文：</label>
			<div class="controls">
				<form:input path="breedTypeEn" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="show:showAdvisor:edit"><input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<!--引入jquery和wangEditor.js-->   <!--注意：javascript必须放在body最后，否则可能会出现问题-->
	<script type="text/javascript" src="${ctxStatic}/wangEditor/js/wangEditor.min.js"></script>
	<script type="text/javascript">
		var editor = new wangEditor('experience');
		// 上传图片（举例）
		editor.config.uploadImgUrl = '${ctx}/sys/file/editorUpload';

		editor.config.uploadImgFileName = 'editorImg';
		// 设置 headers（举例）
		editor.config.uploadHeaders = {
			'Accept' : 'text/x-json'
		};

		// 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
		editor.config.hideLinkImg = true;
		editor.create();
		var editor = new wangEditor('experienceEn');
		// 上传图片（举例）
		editor.config.uploadImgUrl = '${ctx}/sys/file/editorUpload';

		editor.config.uploadImgFileName = 'editorImg';
		// 设置 headers（举例）
		editor.config.uploadHeaders = {
			'Accept' : 'text/x-json'
		};

		// 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
		editor.config.hideLinkImg = true;
		editor.create();
	</script>
</body>
</html>