<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员统计报表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出会员数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/report/reportMemberArea/exportReportMember");
						$("#searchForm").submit();
						$("#searchForm").attr("action","${ctx}/report/reportMemberArea/memberList");
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/report/reportMemberArea/memberList");
			$("#searchForm").submit();
	    	return false;
	    }
		function openExportPage(){
			parent.layer.open({
				type: 2,
				title: ['导出会员明细', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['500px', '300px'],
				content: ctx+"/report/reportMemberArea/exportForm",
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		};
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/report/reportMemberArea/memberList">会员列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="member" action="${ctx}/report/reportMemberArea/memberList" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="key" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>电话：</label>
				<form:input path="mobile" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li>
				<label>会员类型：</label>
				<form:select path="memberCardType" class="input-small">
					<form:option value="">全部</form:option>
					<form:options items="${fns:getDictList('member_card_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li>
				<label>有效状态：</label>
				<form:select path="isExpires" class="input-medium" >
					<form:option value="">全部</form:option>
					<form:option value="0">无效</form:option>
					<form:option value="1">有效</form:option>
				</form:select>
			</li>
			<li><label>注册省份：</label>
				<form:select path="registerProvince" class="input-medium">
					<form:option value="">全部</form:option>
					<c:forEach items="${provincelist}" var="regionName">
						<form:option value="${regionName}">${regionName}</form:option>
					</c:forEach>
				</form:select>
			</li>
			<li><label>会员有效期：</label>
				<input name="memberEndDateStart" type="text"  maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${member.memberEndDateStart}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>--
				<input name="memberEndDateEnd" type="text"  maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${member.memberEndDateEnd}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li>
				<label>美容会员类型：</label>
				<form:select path="groomerType" class="input-small">
					<form:option value="">全部</form:option>
					<form:option value="no">非会员</form:option>
					<form:options items="${fns:getDictList('user_groomer_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>美容会员有效期：</label>
				<input name="groomerEndDateStart" type="text"  maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${member.groomerEndDateStart}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>--
				<input name="groomerEndDateEnd" type="text"  maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${member.groomerEndDateEnd}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>是否本月新增：</label>
				<form:select path="isAdded" class="input-medium" >
					<form:option value="">全部</form:option>
					<form:option value="0">是</form:option>
					<form:option value="1">否</form:option>
				</form:select>
			</li>
			<li><label>是否本月到期：</label>
				<form:select path="isLoss" class="input-medium">
					<form:option value="">全部</form:option>
					<form:option value="0">是</form:option>
					<form:option value="1">否</form:option>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="report:memberList:export">
				<li class="btns">
					<input id="btnExport" class="btn btn-primary" type="button" value="导出列表"/>
				</li>
			</shiro:hasPermission>
			<shiro:hasPermission name="report:memberList:export">
				<li class="btns">
					<input id="btnSubmit" class="btn btn-primary" type="button" onclick="openExportPage()" value="导出新增到期明细"/>
				</li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<div id="seizeDiv"></div>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员编号</th>
				<th>姓名</th>
				<th>电话</th>
				<th>会员类型</th>
				<th>有效状态</th>
				<th>会员有效期</th>
				<th>注册省份</th>
				<th>美容会员类型</th>
				<th>美容会员有效期</th>
				<th>是否本月新增</th>
				<th>是否本月到期</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="member">
			<tr>
				<td>
					${fns:escapeHtml(member.memberCode) }
				</td>
				<td>
					${fns:escapeHtml(member.name)}
					<c:if test="${!empty member.groomerType}">
						<img width="16px" height="16px" src="${ctxStatic }/images/G.jpg"/>
					</c:if>
				</td>
				<td>
					${fns:escapeHtml(member.mobile)}
				</td>
				<td>
					${fns:getDictLabels(member.memberCardType, 'member_card_type', '')}
				</td>
				<td >			
					<c:if test="${member.isExpires==1}">
						<font style="color:#090">有效</font>
					</c:if>
					<c:if test="${member.isExpires==0}">
						<font style="color:#F00">无效</font>
					</c:if>
				</td>
				<td>
					<c:if test="${member.isLoss==1}">
						<font style="color:red"><fmt:formatDate value="${member.memberEndDate }" pattern="yyyy-MM-dd"/></font>
					</c:if>
					<c:if test="${member.isLoss!=1}">
						<fmt:formatDate value="${member.memberEndDate }" pattern="yyyy-MM-dd"/>
					</c:if>
				</td>
				<td>
					${fns:escapeHtml(member.registerProvince) }
				</td>
				<td>
					${fns:getDictLabels(member.groomerType, 'user_groomer_type', '')}
				</td>
				<td>
					<fmt:formatDate value="${member.groomerEndDate }" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<c:if test="${member.isAdded==1}">
						是
					</c:if>
					<c:if test="${member.isAdded==0}">
						否
					</c:if>
				</td>
				<td>
					<c:if test="${member.isLoss==1}">
						<font style="color:red">是</font>
					</c:if>
					<c:if test="${member.isLoss==0}">
						否
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>