<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>原生犬新闻管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<link rel="stylesheet" type="text/css" href="${ctxStatic }/wangEditor/css/wangEditor.min.css">
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/nativedog/nativeDogNews/">原生犬新闻列表</a></li>
		<li class="active"><a href="${ctx}/nativedog/nativeDogNews/form?id=${nativeDogNews.id}">原生犬新闻<shiro:hasPermission name="nativedog:nativeDogNews:edit">${not empty nativeDogNews.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="nativedog:nativeDogNews:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="nativeDogNews" action="${ctx}/nativedog/nativeDogNews/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">标题：</label>
			<div class="controls">
				<form:input path="title" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">作者：</label>
			<div class="controls">
				<form:input path="author" htmlEscape="false" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">新闻更多信息：</label>
			<div class="controls">
				<form:textarea  htmlEscape="true" path="newsDetail" style="height:400px"   />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="nativedog:nativeDogNews:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<!--引入jquery和wangEditor.js-->   <!--注意：javascript必须放在body最后，否则可能会出现问题-->
	<script type="text/javascript" src="${ctxStatic }/wangEditor/js/wangEditor.min.js"></script>
	<script type="text/javascript">
        var editor = new wangEditor('newsDetail');
        // 上传图片（举例）
        editor.config.uploadImgUrl = '${ctx}/sys/file/nativeDogUpload';

        editor.config.uploadImgFileName = 'editorImg';
        // 设置 headers（举例）
        editor.config.uploadHeaders = {
            'Accept' : 'text/x-json'
        };

        // 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
        editor.config.hideLinkImg = true;
        editor.create();
	</script>
</body>
</html>