<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/handler/handlerRegister/">报名列表</a></li>
		<li class="active"><a href="${ctx}/handler/handlerRegister/form?id=${handlerRegister.id}">报名<shiro:hasPermission name="handler:handlerRegister:edit">${not empty handlerRegister.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="handler:handlerRegister:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="handlerRegister" action="${ctx}/handler/handlerRegister/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<h3>会员基本信息</h3>
		
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" readonly="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" readonly="true" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:radiobuttons path="gender" items="${fns:getDictList('user_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="" disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">电话：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
			<div class="controls">
				<span><input id="showLevel1" name="showLevel" type="radio" <c:if test="${handlerRegister.showLevel=='none' }">checked</c:if> value="none"><label for="showLevel1">无</label></span>
				<span><input id="showLevel2" name="showLevel" type="radio" <c:if test="${handlerRegister.showLevel=='MASTER' }">checked</c:if> value="MASTER"><label for="showLevel2">教师</label></span>
				<span><input id="showLevel3" name="showLevel" type="radio" <c:if test="${handlerRegister.showLevel=='C' }">checked</c:if> value="C"><label for="showLevel3">C</label></span>
				<span><input id="showLevel4" name="showLevel" type="radio" <c:if test="${handlerRegister.showLevel=='B' }">checked</c:if> value="B"><label for="showLevel4">B</label></span>
				<span><input id="showLevel5" name="showLevel" type="radio" <c:if test="${handlerRegister.showLevel=='A' }">checked</c:if> value="A"><label for="showLevel5">A</label></span>
				<span><input id="showLevel6" name="showLevel" type="radio" <c:if test="${handlerRegister.showLevel=='预职业组' }">checked</c:if> value="预职业组"><label for="showLevel6">预职业组</label></span>
				<span><input id="showLevel7" name="showLevel" type="radio" <c:if test="${handlerRegister.showLevel=='专业选手组' }">checked</c:if> value="专业选手组"><label for="showLevel7">专业选手组</label></span>
<%-- 				<form:radiobuttons path="showLevel" items="${fns:getDictList('groomer_test_level')}" itemLabel="label" itemValue="value" htmlEscape="false" class="" />
 --%>			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训学校：</label>
			<div class="controls">
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>赛事信息</h3>	
		<div class="control-group">
			<label class="control-label">报名序号：</label>
			<div class="controls">
				<form:input path="registerCode" readonly="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">赛事名称：</label>
			<div class="controls">
				<form:input path="handlerShow.showName" htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true" />
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">桌面审查犬：</label>
			<div class="controls">
				<form:input path="desktopReviewerDog" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">地面审查犬：</label>
			<div class="controls">
				<form:input path="floorReviewerDog" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">任意品种：</label>
			<div class="controls">
				<form:input path="anyBreed" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">美容品种：</label>
			<div class="controls">
				<form:input path="groomerBreed" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
		<label class="control-label">审核状态：</label>
				<div class="controls">
				<form:select path="reviewState" class="input-medium">
					<form:option value="0" label="未审核"/>
					<form:option value="1" label="通过"/>
					<form:option value="2" label="未通过"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="reviewRemarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="handler:handlerRegister:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>