<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>业务分类管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/goods/sysBusinessCate/">业务分类列表</a></li>
		<shiro:hasPermission name="goods:sysBusinessCate:add"><li><a href="${ctx}/goods/sysBusinessCate/editForm">业务分类添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="sysBusinessCate" action="${ctx}/goods/sysBusinessCate/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>分类名称：</label>
				<form:input path="cateName" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>分类编号：</label>
				<form:input path="cateCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>分类名称</th>
				<th>分类编号</th>
				<th>排序</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="sysBusinessCate">
			<tr>
				<td>
					${sysBusinessCate.cateName}
				</td>
				<td>
					${sysBusinessCate.cateCode}
				</td>
				<td>
					${sysBusinessCate.sort}
				</td>
				<td>
					<a href="${ctx}/goods/sysBusinessCate/viewForm?id=${sysBusinessCate.id}">查看</a>
					<shiro:hasPermission name="goods:sysBusinessCate:edit">
    				<a href="${ctx}/goods/sysBusinessCate/editForm?id=${sysBusinessCate.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="goods:sysBusinessCate:del">
					<a href="${ctx}/goods/sysBusinessCate/delete?id=${sysBusinessCate.id}" onclick="return confirmx('确认要删除该业务分类吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>