<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>新生犬登记管理</title>
	<meta name="decorator" content="default"/>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<style type="text/css">
		.jbox-body .jbox-icon{
			top:50px!important;
		}
		.jbox-button-panel {
		    border-top: 1px solid #ccc;
		    background-color: #eee;
		    padding:0px!important;
		}
		.alert-danger, .alert-error{
			color: #bd4247;
		    background-color: #f2bdb1;
		    border-color: #f0a5a4;
		    text-align: justify;
		    text-justify: newspaper;
		    word-break: break-all;
		}
	</style>
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function removeRepeatRecord(){
			var repeatDogIds = "";
			var repeatDogIdSize = $("input[name='repeatDogId']:checkbox:checked").size();
			if(repeatDogIdSize == 0){
				$.jBox.error("请选择要删除的记录后重试！","系统提示");
				return;
			}
			$("input[name='repeatDogId']:checkbox:checked").each(function(index,obj){ 
				repeatDogIds += $(obj).val();
				if(repeatDogIdSize > index+1){
					repeatDogIds += ",";
				}
			});
			batchRemoveRepeatRecord(repeatDogIds);
		}
		
		function batchRemoveRepeatRecord(repeatDogIds){
			if(repeatDogIds == null || repeatDogIds == ''){
				$.jBox.error("请选择要删除的记录后重试！","系统提示");
				return;
			}
			$.jBox.confirm("确认要进行此操作吗？","系统提示",function(v,h,f){
				if(v=="ok"){
					loadFun("btnRemove");
					$.ajax({
						url:'${ctx}/newdogchip/dogChip/removeRepeatRecord/${repeatBirthCode}',
						data:JSON.stringify(repeatDogIds.split(",")),
						contentType: 'application/json;charset=UTF-8',
						type:'post',
						cache:false,
						success:function(json){
							if(json.rc==0){
								window.location.reload();
								$.jBox.tip("删除重复记录成功，页面正在刷新，请稍后...", 'loading');
							}else{
								closeLoadFun("btnRemove");
								$.jBox.error(json.msg,"系统提示");
							}
						},
						error:function(){
							closeLoadFun("btnRemove");
							$.jBox.error("网络或服务异常，请检查是否联网！","系统提示");
						}
					});
					
				}
			},{buttonsFocus:2,buttons: {'取消':'cancel','确定':'ok'}});
		}
		
		function loadFun(btnId){
			layer.load();
			$("#"+btnId).prop("disabled",true);
		}
		
		function closeLoadFun(btnId){
			layer.closeAll('loading');
			$("#"+btnId).prop("disabled",false);
		}
	</script>
	
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/newdogchip/dogChip/">新生犬登记列表</a></li>
	</ul>
	<sys:message content="${message}"/>
	<form:form id="searchForm" modelAttribute="dogChip" action="${ctx}/newdogchip/dogChip/" method="post" class="breadcrumb form-search">
		<div style="text-align: center;font-size: 20px;height:200px;">
			<div style="padding-top:80px;line-height:40px;">系统检测到出生纸编号为&nbsp;<span style="color:red;">${repeatBirthCode}</span>&nbsp;存在多次申请血统证书的记录，请处理后再次查询血统证书列表</div> 
		</div>
		<table id="contentTable" class="table table-striped table-bordered table-condensed">
			<thead>
				<tr>
					<th style="text-align:center;">选择</th>
					<th>血统证书号</th>
					<th>出生纸编号</th>
					<th>英文姓名</th>
					<th>性别</th>
					<th>出生日期</th>
					<th>创建时间</th>
					<th>芯片号</th>
					<th>犬主人</th>
					<th>证书类型</th>
					<th>鼻纹状态</th>
				</tr>
			</thead>
			<tbody>
			<c:forEach items="${repeatDogList}" var="dog">
				<tr>
					<td style="text-align:center;">
						<c:set var="createDateStr">
							<fmt:formatDate value="${dog.createDate}" pattern="yyyyMMddHHmmss"/>
						</c:set>
						<c:set var="minDateStr">
							<fmt:formatDate value="${minDate}" pattern="yyyyMMddHHmmss"/>
						</c:set>
						<input type="checkbox" name="repeatDogId" ${minDateStr eq createDateStr ? 'checked':''} value="${dog.id}"/>
					</td>
					<td>
						<font color="red">${fns:desensitize(dog.pedigreeCertifiedCode,1) }</font>
					</td>
					<td>
						${fns:escapeHtml(dog.birthCertificateLevelCode) }
					</td>
					<td>
						${fns:escapeHtml(dog.nameEn)}
					</td>
					<td>
						${fns:getDictLabel(dog.gender, 'dog_gender', '')}
					</td>
					<td>
						<fmt:formatDate value="${dog.birthdate}" pattern="yyyy-MM-dd"/>
					</td>
					<td>
						<font color="red"><fmt:formatDate value="${dog.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/></font>
					</td>
					<td>
						${fns:desensitize(dog.identificationFlag,2) }
					</td>
					<td title="${fns:escapeHtml(dog.memberCode)}">
						${fns:escapeHtml(dog.dogOwner)}
						<c:if test="${dog.secondDogOwner!=''&&dog.secondDogOwner!=null}">/${fns:escapeHtml(dog.secondDogOwner) }</c:if>
					</td>
					<td>
						<c:if test="${dog.ecertFlag == '0'}">
							纸质版
						</c:if>
						<c:if test="${dog.ecertFlag == '1'}">
							电子版
						</c:if>
					</td>
					<td>
						<c:if test="${empty dog.noseFlag}">
							未采集
						</c:if>
						<c:if test="${not empty dog.noseFlag}">
							已采集
						</c:if>
					</td>
				</tr>
			</c:forEach>
			</tbody>
		</table>
		<div class="form-actions" style="text-align: center;">
			<input id="btnRemove" class="btn btn-primary" type="button" value="删除重复记录" onclick="removeRepeatRecord();"/> 
			<div style="margin-top:10px;"><font color="#f0ad4e">如有疑问，可联系技术部处理</font></div>
		</div>
	</form:form>
</body>
</html>