<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>冠军登录信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            
        });
    </script>
</head>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>血统证书号</th>
				<th>会员名</th>
				<th>申请日期</th>
				<th>出口国家</th>
				<th>接收人</th>
				<th>地址</th>
				<th>操作人</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>管理</th>
				<th>打印</th>
				<shiro:hasPermission name="dogexport:dogPedigreeCertifiedExport:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogPedigreeCertifiedExport">
			<tr>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedExport.pedigreeCertified)}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedExport.paymentMemberCode)}">
					${fns:escapeHtml(dogPedigreeCertifiedExport.dogOwner)}
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedExport.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedExport.exportCountry)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedExport.exporter)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedExport.exportDestination)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedExport.operator)}
				</td>
				<td style="color:${dogPedigreeCertifiedExport.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogPedigreeCertifiedExport.paymentState, 'user_payment_state', '')}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedExport.reviewRemarks)}">
					<c:if test="${dogPedigreeCertifiedExport.paymentState=='2'}">
					<c:choose>
						<c:when test="${dogPedigreeCertifiedExport.reviewState=='0'}">
							<a style="color:#F00" onclick="auditForm('${fns:escapeHtml(dogPedigreeCertifiedExport.id)}')">${fns:getDictLabel(dogPedigreeCertifiedExport.reviewState, 'review_state', '')}</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogPedigreeCertifiedExport.reviewState, 'review_state', '')}
						</c:otherwise>
					</c:choose>
					</c:if>
				</td>
				<td>
					<c:if test="${dogPedigreeCertifiedExport.paymentState=='2'&&dogPedigreeCertifiedExport.reviewState=='1'}">
						<c:choose>
							<c:when test="${dogPedigreeCertifiedExport.processState=='0'}">
								<a style="color:#F00" href="${ctx}/dogexport/dogPedigreeCertifiedExport/resolve?id=${fns:escapeHtml(dogPedigreeCertifiedExport.id)}"
									onclick="return confirmx('确认要处理该证书出口吗？', this.href)">
								${fns:getDictLabel(dogPedigreeCertifiedExport.processState, 'proccess_state', '')}
								</a>
							</c:when>
							<c:when test="${dogPedigreeCertifiedExport.processState=='1'}">
								${fns:getDictLabel(dogPedigreeCertifiedExport.processState, 'proccess_state', '')}
							</c:when>
						</c:choose>
					</c:if>
				</td>
				<td>
					打印
				</td>
				<shiro:hasPermission name="dogexport:dogPedigreeCertifiedExport:edit"><td>
				<c:if test="${!dogPedigreeCertifiedExport.businessRefundState}">
					<a href="${ctx}/dogexport/dogPedigreeCertifiedExport/delete?id=${dogPedigreeCertifiedExport.id}" onclick="return confirmx('确认要删除该出口证书申请吗？', this.href)">删除</a>
				</c:if>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>