<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员扣款</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		});
		function closeLayer(){
			parent.layer.closeAll();
		}
		function resolve(){
		    $.post('${ctx}/dnaarchive/dogDnaArchive/resolve',
		    		$('#inputForm').serialize(),
			function(data) {
 				if(data.rc==0){
					alert("处理成功！");
					parent.isYes = true;
					parent.layer.closeAll();
				}else{
					alert("处理失败,错误信息："+data.msg);
				} 
		    });
		}
	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="dogDna" class="form-horizontal">
	<input type="hidden" name="dnaArchiveId" value="${fns:escapeHtml(dogDna.dnaArchiveId)}">
	<input type="hidden" name="dogId" value="${fns:escapeHtml(dogDna.dogId)}">
	<input type="hidden" name="dogBreed" value="${fns:escapeHtml(dogDna.dogBreed)}">
	<div class="control-group">
		<label class="control-label">血统证书编号：</label>
		<div class="controls">
			${fns:escapeHtml(dogDna.pedigreeCertifiedCode)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬名：</label>
		<div class="controls">
			${dogDna.nameCn}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">出生日期：</label>
		<div class="controls">
			<fmt:formatDate value="${dogDna.birthdate}" pattern="yyyy-MM-dd"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">性别：</label>
		<div class="controls">
			${fns:getDictLabel(dogDna.gender, 'dog_gender', '')}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">DNA检测结果：</label>
		<div class="controls">
			<textarea name="dnaResult" rows="3" cols="150" class="input-xxlarge">${fns:escapeHtml(dogDna.dnaResult)}</textarea>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">DNA检测备注：</label>
		<div class="controls">
			<textarea name="dnaResultRemark" rows="2" cols="20" class="input-xlarge">${fns:escapeHtml(dogDna.dnaResultRemark)}</textarea>
		</div>
	</div>
	<%-- <c:if test="${fns:startsWith(dogDna.dogBreed,'NB')}">
		<div class="control-group">
			<label class="control-label">DNA登记编号：</label>
			<div class="controls">
				<input type="text" id="dnaCode" name="dnaCode" value="${fns:escapeHtml(dogDna.dnaCode)}"
					   class="input-xlarge">
			</div>
		</div>
	</c:if> --%>
	<div class="control-group" style="text-align: center;">
		<input id="btnSubmit" class="btn btn-primary" type="button" value="保 存" onclick="resolve()"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="关 闭" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>