<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>证书出口申请</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			 //悬浮提示插件
            $(document).tooltip();
			$("#inputForm").validate({
				submitHandler: function(form){
					$("#btnSubmit").attr("disabled" , "disabled");
					loading('正在提交，请稍等...');
 				    $.post('${ctx}/birthcertificate/dogBirthCertificate/add',
 				    		$('#inputForm').serialize(),
 					function(data) {
 		 				if(data.rc==0){
 							alert("订单录入成功！");
 							$("#btnSubmit").removeAttr("disabled");
 							parent.isYes = true;
 							parent.layer.closeAll();
 						}else{
 							alert("提交失败,错误信息："+data.msg);
 							$("#btnSubmit").removeAttr("disabled");
 						} 
 				    });
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
					$("#btnSubmit").removeAttr("disabled");
				}
			});
		});
		function closeLayer(){
			parent.layer.closeAll();
		}
		function getByFmdogBreedCertifiedCode(){
			var fmdogBreedCertifiedCode = $("#fmdogBreedCertifiedCode").val();
			if(fmdogBreedCertifiedCode==''){
				$.jBox.alert("请输入配种证明号！","提示");
		    	$('#breedDate').html('');
		    	$('#dogBreed').html('');
		    	$('#maleDogOwner').html('');
		    	$('#malePedigreeCertified').html('');
		    	$('#femaleDogOwner').html('');
		    	$('#femalePedigreeCertified').html('');
				return;
			}
		    $.post('${ctx}/birthcertificate/dogBirthCertificate/getByFmdogBreedCertifiedCode', {
		    	fmdogBreedCertifiedCode: fmdogBreedCertifiedCode
		    }, function(data) {
		    	$('#breedDate').html(data.breedDate);
		    	$('#dogBreed').html(data.dogBreed);
		    	$('#maleDogOwner').html(data.maleDogOwner);
		    	$('#malePedigreeCertified').html(data.malePedigreeCertified);
		    	$('#femaleDogOwner').html(data.femaleDogOwner);
		    	$('#femalePedigreeCertified').html(data.femalePedigreeCertified);
		    	var dogColorArray = data.dogColor.split(",");
		    	selectTemplet = "<option value =''>请选择毛色</option>";
		    	$.each(dogColorArray, function(i,val) {
		    		var array = val.split("=");
					selectTemplet = selectTemplet + "<option value ='"+array[0]+"'>"+array[1]+"</option>";
			    });
		    });
		}

		var selectTemplet = '';

		function changeTable(){
			$('.male').remove();
			$('.female').remove();
			var maleNum = $('#maleNum').val();
			var femaleNum = $('#femaleNum').val();
			if(maleNum==''){
				maleNum = 0;
			}
			if(femaleNum==''){
				femaleNum = 0;
			}
			var trMale = '<tr class="male"><td>公<input type="hidden" name="dogBirthCertificateList[{{idx}}].dogGender" value="1"/></td>'
							+'<td><input type="text" class="input-medium required dogEnName" name="dogBirthCertificateList[{{idx}}].dogEnName"/></td>'
							+'<td><select name="dogBirthCertificateList[{{idx}}].colorFlag" class="required" >'+selectTemplet+'</select></td></tr>';
			var trFemale = '<tr class="female"><td>母<input type="hidden" name="dogBirthCertificateList[{{idx}}].dogGender" value="2"/></td>'
							+'<td><input type="text" class="input-medium required dogEnName" name="dogBirthCertificateList[{{idx}}].dogEnName"/></td>'
							+'<td><select name="dogBirthCertificateList[{{idx}}].colorFlag" class="required" >'+selectTemplet+'</select></td></tr>';

			var j = 0;
			for(var i=0;i<maleNum;i++){
				$('#contentTable').append(trMale.replace(/{{idx}}/g,j));
				j++;
			}
			for(var i=0;i<femaleNum;i++){
				$('#contentTable').append(trFemale.replace(/{{idx}}/g,j));
				j++;
			}

		}
		function getDogNames(){
			var maleNum = $('#maleNum').val();
			var femaleNum = $('#femaleNum').val();
			if(maleNum==''&&femaleNum==''){
				$.jBox.alert("请输入同胎犬数！","提示");
				return;
			}
		    $.post('${ctx}/birthcertificate/dogBirthCertificate/getDogNames', {
		    	maleNum: maleNum,
		    	femaleNum: femaleNum
		    }, function(data) {
		    	$.each(data.dogNameList.split(","), function(i,val) {
		    		$('.dogEnName').eq(i).val(val);
			    });
		    });
		}
	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="dogBirthCertificateApply" class="form-horizontal">
	<form:hidden path="memberCode"/>
	<form:hidden path="paymentChargingItemId"/>
	<form:hidden path="runningNumber"/>
	<div class="control-group">
		<label class="control-label">配种证明号：</label>
		<div class="controls">
			<form:input id="fmdogBreedCertifiedCode" path="fmdogBreedCertifiedCode" htmlEscape="false" maxlength="64" class="input-medium required"/>
			<input id="btnCancel" class="btn" type="button" value="查询" onclick="getByFmdogBreedCertifiedCode()"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">配种日期：</label>
		<div class="controls" id="breedDate">
			
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬种：</label>
		<div class="controls" id="dogBreed">
			
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">公犬主人：</label>
		<div class="controls" id="maleDogOwner">
			
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">公犬血统证书号：</label>
		<div class="controls" id="malePedigreeCertified">
			
	</div>
	<div class="control-group">
		<label class="control-label">母犬主人：</label>
		<div class="controls" id="femaleDogOwner">
			
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">母犬血统证书号：</label>
		<div class="controls" id="femalePedigreeCertified">
			
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">幼犬出生日期：</label>
		<div class="controls">
		    <input name="dogBirthday" type="text" readonly="readonly" maxlength="20" class="input-large Wdate required"
			 value="" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">同胎犬数：</label>
		<div class="controls">
		    <form:input id="maleNum" type="number" path="" htmlEscape="false" onchange="changeTable()" maxlength="2" class="input-mini required"/>公
		    <form:input id="femaleNum" type="number" path="" htmlEscape="false" onchange="changeTable()" maxlength="2" class="input-mini required"/>母
		</div>
	</div>
	<table class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>性别</th>
				<th>犬名&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input class="btn btn-primary" type="button" value="随机犬名" onclick="getDogNames()"/></th>
				<th>毛色</th>
			</tr>
		</thead>
		<tbody id="contentTable" >

		</tbody>
	</table>
	<div class="control-group" style="text-align: center;">
		<input id="btnSubmit" class="btn btn-primary" type="submit" value="确认提交"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="关闭返回" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>