<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>出生证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/birthcertificate/dogBirthCertificate/">出生证明列表</a></li>
		<li class="active"><a href="${ctx}/birthcertificate/dogBirthCertificate/form?id=${fns:escapeHtml(dogBirthCertificate.id)}">出生证明<shiro:hasPermission name="birthcertificate:dogBirthCertificate:edit">${not empty dogBirthCertificate.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="birthcertificate:dogBirthCertificate:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogBirthCertificate" action="${ctx}/birthcertificate/dogBirthCertificate/audit" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">出生纸编号：</label>
			<div class="controls">
				${fns:desensitize(dogBirthCertificate.birthCerRegCode,4)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书号：</label>
			<div class="controls">
				${fns:desensitize(dogBirthCertificate.pedigreeCertified,1)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">英文犬名：</label>
			<div class="controls">
				${fns:escapeHtml(dogBirthCertificate.dogEnName)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只性别：</label>
			<div class="controls">
				<form:radiobuttons path="dogGender" items="${fns:getDictList('dog_gender')}" disabled="true" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主姓名：</label>
			<div class="controls">
				${fns:escapeHtml(dogBirthCertificate.dogOwenr)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主会员号：</label>
			<div class="controls">
				${fns:escapeHtml(dogBirthCertificate.memberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">第二犬主：</label>
			<div class="controls">
				${fns:escapeHtml(dogBirthCertificate.secondDogOwner)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">第二犬主会员号：</label>
			<div class="controls">
				${fns:escapeHtml(dogBirthCertificate.secondOwnerMemberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<fmt:formatDate value="${dogBirthCertificate.dogBirthday}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">芯片号码：</label>
			<div class="controls">
				${fns:desensitize(dogBirthCertificate.identificationFlag,2)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">颜色及标志：</label>
			<div class="controls">
                <form:select id="colorFlag" path="colorFlag" disabled="true" class="input-xlarge required">
                	<form:options items="${dogColorMarkList}" itemLabel="dogColorMarkCn" itemValue="dogColorMarkCode" htmlEscape="false"/>
                </form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">DNA编号：</label>
			<div class="controls">
				${fns:desensitize(dogBirthCertificate.dna,6)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">配种证明号：</label>
			<div class="controls">
				${fns:escapeHtml(dogBirthCertificate.fmdogBreedCertifiedCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">繁育人：</label>
			<div class="controls">
				${fns:escapeHtml(dogBirthCertificate.breeder)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">父犬证书号：</label>
			<div class="controls">
				${fns:desensitize(dogBirthCertificate.fdogPedigreeCertified,1)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">母犬证书号：</label>
			<div class="controls">
				${fns:desensitize(dogBirthCertificate.mdogPedigreeCertified,1)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('dog_birth_certificate_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核的意见：</label>
			<div class="controls">
				<form:input path="reviewRemarks" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">添加日期：</label>
			<div class="controls">
				<fmt:formatDate value="${dogBirthCertificate.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div style = "clear:both;"/>
<%-- 		<div class="control-group">
			<label class="control-label">繁殖人会员号：</label>
			<div class="controls">
				<form:input path="breederMemberCode" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">临时会员号：</label>
			<div class="controls">
				<form:input path="tempMemberCode" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">临时用户名：</label>
			<div class="controls">
				<form:input path="tempUserName" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">种类：</label>
			<div class="controls">
				<form:input path="dogBreed" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">同胎犬数：</label>
			<div class="controls">
				<form:input path="sameBatchNum" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">单价：</label>
			<div class="controls">
				<form:input path="price" htmlEscape="false" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">抵扣：</label>
			<div class="controls">
				<form:input path="deduction" htmlEscape="false" maxlength="11" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">添加用户：</label>
			<div class="controls">
				<form:input path="addUser" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">是否加急：</label>
			<div class="controls">
				<form:select path="urgent" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('urgent_status')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">识别码：</label>
			<div class="controls">
				<form:input path="snCode" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核时间：</label>
			<div class="controls">
				<input name="reviewTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogBirthCertificate.reviewTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">流水号：</label>
			<div class="controls">
				<form:input path="runningNumber" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">付款的状态：</label>
			<div class="controls">
				<form:input path="paymentState" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">付款时间：</label>
			<div class="controls">
				<input name="paymentTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogBirthCertificate.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">流程变更的时间：</label>
			<div class="controls">
				<input name="processTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogBirthCertificate.processTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">流程状态：</label>
			<div class="controls">
				<form:input path="processState" htmlEscape="false" maxlength="20" class="input-xlarge "/>
			</div>
		</div> --%>
		<div class="form-actions">
			<shiro:hasPermission name="birthcertificate:dogBirthCertificate:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>