<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合作机构、合作医院管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/club/form?id=${org.id}">合作机构<shiro:hasPermission name="sys:club:edit">${not empty org.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="sys:club:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="org" action="${ctx}/sys/club/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="orgType" value="club"/>
		<sys:message content="${message}"/>		
		<div style="clear:both;"></div>
		<div class="control-group">
			<label class="control-label">登录帐号：</label>
			<div class="controls">
				<input type="text" name="user.loginName" class="input-xlarge required" />
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登录密码：</label>
			<div class="controls">
				<input type="password" name="user.password" class="input-xlarge required" />
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">机构名称：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">联系人：</label>
			<div class="controls">
				<form:input path="contact" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">联系电话：</label>
			<div class="controls">
				<form:input path="tel" htmlEscape="false" maxlength="50" class="input-xlarge required isTel"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="province" path="member.province" class="input-small required">
					<form:option value=""></form:option>
					<c:forEach items="${province}" var="p">
						<form:option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</form:option>
					</c:forEach>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="city" path="member.city" class="input-small required">
					<form:option value=""></form:option>
					<c:forEach items="${city}" var="c">
						<form:option value="${fns:escapeHtml(c.name) }">${fns:escapeHtml(c.name) }</form:option>
					</c:forEach>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				var extId = $("#province").val();
				//异步请求数据
				var url="${ctx}"+"/sys/area/treeData";
				$.get(url,{extId:extId},function(data){
					var content = "<option value=''></option>";
					for(var i in data){
						content+="<option value='"+data[i].name+"'>"+data[i].name+"</option>"
					}
					$("#city").html(content).trigger("change");
				},"json")
				
			})
		</script>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="member.street" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">截止日期：</label>
			<div class="controls">
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${org.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
					<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">押金：</label>
			<div class="controls">
				<form:input path="deposit" htmlEscape="false" class="input-xlarge isFloatGtZero"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴纳押金的时间：</label>
			<div class="controls">
				<input name="depositDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${org.depositDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">芯片扫描仪：</label>
			<div class="controls">
				<input type="radio" name="scanner" value="yes"/>是
				<input type="radio" name="scanner" value="no" checked="checked"/>否
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="form-actions">
			<shiro:hasPermission name="sys:club:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>